// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : NX32 NX64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Nx/hkNxStreamReader.h>

using namespace std;

hkNxStreamReader* hkNxStreamReader::open( const char* nameIn )
{
    // nn::fs::OpenFile() will fail hard for bad paths so check validity first
    {
        const int colonPos = hkString::indexOf(nameIn, ':');
        if( ( colonPos != hkString::lastIndexOf(nameIn, ':') ) )
        {
            return HK_NULL;
        }
        hkStringBuf path = nameIn;
        path.chompStart( colonPos + 1 );
        path.pathNormalize();
        if( path.startsWith( "/../" ) )
        {
            return HK_NULL;
        }
    }

    nn::fs::FileHandle file;
    nn::Result result = nn::fs::OpenFile(&file, nameIn, nn::fs::OpenMode_Read);

    if (result.IsSuccess())
    {
        return new hkNxStreamReader(file);
    }
    return HK_NULL;
}

hkNxStreamReader::hkNxStreamReader(nn::fs::FileHandle& handle)
    : m_offset(0)
{
    m_isOk = handle.handle != HK_NULL;
    if (m_isOk)
    {
        m_handle = handle;
        if (!(nn::fs::GetFileSize(&m_size, m_handle).IsSuccess()))
        {
            m_isOk = false;
        }
    }
}

hkNxStreamReader::~hkNxStreamReader()
{
    if (m_handle.handle != HK_NULL)
    {
        nn::fs::CloseFile(m_handle);
    }
}

int hkNxStreamReader::read( void* buf, int nbytes)
{
    int nread = peek(buf, nbytes);
    m_offset += nread;
    if (nbytes && (nread == 0))
    {
        m_isOk = false;  // EOF
    }
    return nread;
}

hkBool hkNxStreamReader::isOk() const
{
    return m_isOk;
}

int hkNxStreamReader::peek( void* buf, int nbytes)
{
    HK_ASSERT(0x6400412c, m_isOk, "Read from closed file");
    size_t nread = 0;
    nn::Result result = nn::fs::ReadFile(&nread, m_handle, m_offset, buf, nbytes);
    if (!result.IsSuccess())
    {
        m_isOk = false;
    }
    return int(nread);
}

/* seek, tell */

hkResult hkNxStreamReader::seek( int offset, SeekWhence whence)
{
    int pos = -1;
    switch (whence)
    {
        case STREAM_SET:
            pos = offset;
            break;
        case STREAM_CUR:
            pos = m_offset + offset;
            break;
        case STREAM_END:
            pos = m_size + offset;
            break;
    }
    hkResult ok = HK_SUCCESS;
    if (pos < 0)
    {
        pos = 0;
        ok = HK_FAILURE;
    }
    else if (pos > m_size)
    {
        pos = m_size;
        ok = HK_FAILURE;
    }
    m_isOk = true;
    m_offset = pos;
    return HK_SUCCESS;
}

int hkNxStreamReader::tell() const
{
    return (int)m_offset;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
