// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : NX32 NX64
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

class hkNxFileSystem : public hkFileSystem
{
    public:

        HK_DECLARE_CLASS(hkNxFileSystem, New);

        virtual hkResult remove(_In_z_ const char* path) HK_OVERRIDE;
        virtual hkResult mkdir(_In_z_ const char* path, CreateFlag flag) HK_OVERRIDE;

        virtual hkResult stat(_In_z_ const char* path, Entry& entryOut ) HK_OVERRIDE;
        virtual hkRefNew<Iterator::Impl> createIterator( const char* top, const char* wildcard ) HK_OVERRIDE;

        virtual const char* getOperatingSystemPath( const char* pathIn, hkStringBuf& pathOut, OSPathFlags flags ) HK_OVERRIDE;

protected:

        virtual hkRefNew<hkStreamReader> _openReader(const char* name, OpenFlags flags) HK_OVERRIDE;
        virtual hkRefNew<hkStreamWriter> _openWriter(const char* name, OpenFlags flags) HK_OVERRIDE;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
