// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : NX32 NX64
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Platform/Nx/hkNxFileSystem.h>
#include <Common/Base/System/Io/Platform/Nx/hkNxStreamReader.h>
#include <Common/Base/System/Io/Platform/Nx/hkNxStreamWriter.h>

#include <nn/fs.h>

hkRefNew<hkStreamReader> hkNxFileSystem::_openReader(const char* name, OpenFlags flags)
{
    return _handleFlags(hkNxStreamReader::open(name), flags);
}

hkRefNew<hkStreamWriter> hkNxFileSystem::_openWriter(const char* name, OpenFlags flags)
{
    return _handleFlags(hkNxStreamWriter::open(name, flags), flags );
}

hkResult hkNxFileSystem::remove(_In_z_ const char* path)
{
    nn::fs::DirectoryEntryType type;
    if (nn::fs::GetEntryType(&type, path).IsSuccess())
    {
        if (type == nn::fs::DirectoryEntryType_Directory)
        {
            if (nn::fs::DeleteDirectoryRecursively(path).IsSuccess())
            {
                return HK_SUCCESS;
            }
        }
        else
        {
            if (nn::fs::DeleteFile(path).IsSuccess())
            {
                return HK_SUCCESS;
            }
        }
    }
    return HK_FAILURE;
}

hkResult hkNxFileSystem::mkdir(_In_z_ const char* path, CreateFlag flag)
{
    nn::Result res = nn::fs::CreateDirectory(path);
    if (res.IsSuccess())
    {
        return HK_SUCCESS;
    }
    return nn::fs::ResultPathAlreadyExists::Includes(res) ? HK_E_ALREADY_EXISTS : HK_FAILURE;
}

//hkFileSystem::TimeStamp s_nanoFromDateTime( const SceDateTime& dt )
//{
    //return hkUint64(dt.second)*1000000000LL + hkUint64(dt.microsecond) * 1000;
//}

hkResult hkNxFileSystem::stat(_In_z_ const char* path, hkFileSystem::Entry& entryOut )
{
    nn::fs::DirectoryEntryType type;
    if (nn::fs::GetEntryType(&type, path).IsSuccess())
    {
        //hkFileSystem::Entry::F_ISDIR
        if (type == nn::fs::DirectoryEntryType_Directory)
        {
            entryOut.setAll(this, path, hkFileSystem::Entry::F_ISDIR, TimeStamp(), 0);
            return HK_SUCCESS;
        }
        else
        {
            hkNxStreamReader* reader = hkNxStreamReader::open(path);
            if (reader != HK_NULL)
            {
                entryOut.setAll(this, path, hkFileSystem::Entry::F_ISFILE, TimeStamp(), reader->getSize());
                delete reader;
            }
            return HK_SUCCESS;
        }
    }
    return HK_FAILURE;
}

namespace
{
    struct NxIter : public hkFileSystem::Iterator::Impl
    {
        enum
        {
            MAX_DIR_ENTRIES = 512
        };

        NxIter(hkFileSystem* fs, const char* top, const char* wildcard)
            : m_fs(fs), m_top(top), m_wildcard(wildcard), m_count(0), m_current(0)
        {
            nn::fs::DirectoryHandle handle;
            hkStringBuf new_top(top);
            if (top[strlen(top) - 1] == ':')
            {
                new_top.append("/");  // ":/" is required after a mount name
            }
            if (nn::fs::OpenDirectory(&handle, new_top.cString(), nn::fs::OpenDirectoryMode_All).IsSuccess())
            {
                //int64_t readNum = 0;
                if (nn::fs::ReadDirectory(&m_count, m_entry, handle, MAX_DIR_ENTRIES).IsFailure())
                {
                    m_count = 0;
                }
                nn::fs::CloseDirectory(handle);
            }
        }

        ~NxIter()
        {
        }

        virtual bool advance(hkFileSystem::Entry& entryOut)
        {
            while (m_current < m_count)
            {
                if (hkFileSystem::Iterator::nameAcceptable(m_entry[m_current].name, m_wildcard))
                {
                    entryOut.setAll
                        (
                        m_fs,
                        hkStringBuf(m_top).pathAppend(m_entry[m_current].name),
                        (m_entry[m_current].directoryEntryType == nn::fs::DirectoryEntryType_Directory) ? hkFileSystem::Entry::F_ISDIR : hkFileSystem::Entry::F_ISFILE,
                        0,  // cannot get modification time?
                        m_entry[m_current].fileSize
                        );
                    ++m_current;
                    return true;
                }
                ++m_current;
            }
            return false;
        }
        hkFileSystem* m_fs;
        hkStringPtr m_top;
        hkStringPtr m_wildcard;

        nn::fs::DirectoryEntry m_entry[MAX_DIR_ENTRIES];
        int64_t m_count;
        int m_current;
    };  // class NxIter
}  // namespace

hkRefNew<hkFileSystem::Iterator::Impl> hkNxFileSystem::createIterator( const char* top, const char* wildcard )
{
    return new NxIter(this, top, wildcard);
}

const char* hkNxFileSystem::getOperatingSystemPath( const char* pathIn, hkStringBuf& pathOut, OSPathFlags flags )
{
    nn::fs::DirectoryEntryType type;
    if (nn::fs::GetEntryType(&type, pathIn).IsSuccess())
    {
        return pathIn;
    }
    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
