// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64 LINUX32 LINUX64 MAC IOS ANDROID DURANGO UWP OSINTERNAL NX32 NX64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/Socket/hkSocket.h>

class HK_EXPORT_COMMON hkBsdSocket : public hkSocket
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS );

#       if defined(HK_PLATFORM_WIN64)
            typedef unsigned __int64 socket_t;
#       elif defined(HK_PLATFORM_WIN32)
            typedef unsigned socket_t;
#       else
            typedef int socket_t;
#       endif

        hkBsdSocket(socket_t s=socket_t(-1));

        virtual ~hkBsdSocket();

        virtual hkBool isOk() const HK_OVERRIDE;

        virtual void close() HK_OVERRIDE;

        virtual int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes) HK_OVERRIDE;

        virtual int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes) HK_OVERRIDE;

        virtual hkResult connect(_In_z_ const char* servername, int portNumber) HK_OVERRIDE;

        virtual hkResult connect( hkInetAddr remoteAddr) HK_OVERRIDE;

        virtual hkResult listen( int port ) HK_OVERRIDE;

        virtual hkResult bind(int port) HK_OVERRIDE;

        virtual hkResult getInetAddr(hkInetAddr& inetAddr) HK_OVERRIDE;

        virtual bool canWrite() const HK_OVERRIDE;

        _Ret_maybenull_ hkSocket* pollForNewClient(_Inout_opt_ hkInetAddr* remoteAddr = HK_NULL) HK_OVERRIDE;
        virtual bool canRead() const HK_OVERRIDE;



        virtual hkResult createDatagramSocket( int port, int listenAddress = 0 ) HK_OVERRIDE;

        virtual int sendTo(_In_reads_bytes_(nbytes) const void* buf, int nbytes, const hkInetAddr& toAddress) HK_OVERRIDE;

        virtual int receiveFrom(_Out_writes_bytes_(nbytes) void* buf, int nbytes, hkInetAddr &fromAddress) HK_OVERRIDE;

        virtual int getLastError() HK_OVERRIDE;

        virtual void getAddress( hkStringBuf& hostOut, int& portOut ) const HK_OVERRIDE;

        virtual hkResult setBlocking(hkBool blocking) HK_OVERRIDE;

        socket_t getSocketInternal() const { return m_socket; }
    protected:

        hkResult createSocket();

        socket_t m_socket;
};

/// Initializes the network for BSD style sockets
void HK_CALL hkBsdNetworkInit();

/// Shuts down the network
void HK_CALL hkBsdNetworkQuit();

void HK_CALL hkBsdGetAddressString( hkStringBuf& );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
