// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 LINUX32 LINUX64 X64 MAC ANDROID METRO UWP OSINTERNAL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class HK_EXPORT_COMMON hkOptionParser
{
public:

    HK_DECLARE_PLACEMENT_ALLOCATOR();

    hkOptionParser(_In_z_ const char* title, _In_z_ const char* desc);

    enum OptionType
    {
        OPTION_BOOL,
        OPTION_COUNTER,
        OPTION_INT,
        OPTION_STRING,
        OPTION_MULTI_STRING
    };

    enum ArgumentsType
    {
        ARGUMENTS_ONE,
        ARGUMENTS_ONE_OR_MORE,
        ARGUMENTS_ZERO_OR_MORE
    };

    enum ParseResult
    {
        PARSE_SUCCESS,
        PARSE_FAILURE,
        PARSE_HELP      // help was sought (using the help option)
    };


    struct MultiOptionValue
    {
        enum
        {
            NUM_MULTI_ARGS = 16
        };

        const char* m_options[NUM_MULTI_ARGS];
        int m_optionCount;
    };

    union OptionValue
    {
        int i;
        unsigned int u;
        const char* s;
        MultiOptionValue ms;
        bool b;
    };

    struct HK_EXPORT_COMMON Option
    {

        Option() {}

        /// Create a string type option
        Option(_In_z_ const char* shortFlag, _In_z_ const char* longFlag, _In_z_ const char* help, _Inout_ const char** value, _In_opt_z_ const char* defaultValue = HK_NULL);

        /// Create a boolean type option
        Option(_In_z_ const char* shortFlag, _In_z_ const char* longFlag, _In_z_ const char* help, _Inout_ bool* value, bool defaultValue = false);

        /// Create a integer type option
        Option(_In_z_ const char* shortFlag, _In_z_ const char* longFlag, _In_z_ const char* help, _Inout_ int* value, int defaultValue = 0);

        /// Create a counter (unsigned integer) type option
        Option(_In_z_ const char* shortFlag, _In_z_ const char* longFlag, _In_z_ const char* help, _Inout_ unsigned int* value, unsigned int defaultValue = 0u);

        // Multi string, 16 arguments
        Option(_In_z_ const char* shortFlag, _In_z_ const char* longFlag, _In_z_ const char* help, _Inout_ MultiOptionValue* value);

        const char* m_shortFlag;
        const char* m_longFlag;
        const char* m_help;
        OptionType m_type;
        OptionValue* m_value;
        OptionValue m_default;
    };

    /// Adds an option to the parser
    bool setOptions(_Inout_updates_(count) Option* options, int count);

    /// Sets the positional arguments
    void setArguments(_In_z_ const char* name, _In_z_ const char* help, ArgumentsType argumentsType, _Inout_updates_all_(count) const char** arguments, int count);

    /// Parse the argument vector and store the result in the variables specified in addOption and setArguments
    ParseResult parse(int argc, _In_reads_(argc) const char** argv, bool acceptShortFlags = true);

    /// Print out the usage/help information for this parser
    void usage(_In_opt_z_ const char* extra = HK_NULL);

private:

    /// Unsorted storage for options
    Option* m_options;
    int m_optionCount;
    const char** m_arguments;
    int m_argumentCount;

    /// Program details
    const char* m_title;
    const char* m_desc;

    /// Arguments details
    const char* m_argumentsName;
    const char* m_argumentsHelp;
    ArgumentsType m_argumentsType;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
