// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

//HK_HAVOK_ASSEMBLY_EXCLUDE_FILE

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

class hkOstream;
class hkStreamWriter;
class hkStringPtr;
class hkStringBuf;
class hkMemoryTrack;
class hkSimdFloat32;
class hkSimdDouble64;
class hkVector4f;
class hkVector4d;
class hkQuaternionf;
class hkQuaterniond;

template<typename FT> class hkMatrix3Impl;
typedef  hkMatrix3Impl<float> hkMatrix3f;
typedef  hkMatrix3Impl<double> hkMatrix3d;

class hkTransformf;
class hkTransformd;

struct hkContainerHeapAllocator;
template<typename T, typename A> class hkArray;

/// Text formatted data writer. Provides functionality similar to std::ostream.
/// All the usual operators are provided plus operators
/// for 64 bit integers. printf style output is also
/// supported.
class HK_EXPORT_COMMON hkOstream : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

            /// Parent type allowing for custom formatting.
        struct CustomFormater
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM, CustomFormater);

            virtual ~CustomFormater() {}
            virtual void writeTo(hkOstream& stream) const=0;
        };

            /// Constructs an hkOstream using the given hkStreamWriter for writing.
        explicit hkOstream(_In_ hkStreamWriter* sr);

            /// Create an ostream connected to a file.
            /// The file is truncated.
        explicit hkOstream(_In_z_ const char* filename);

            /// Create an ostream connected to a memory buffer.
            /// The buffer must exist for the lifetime of this object.
            /// If isString, the buffer is guaranteed to be null terminated.
        hkOstream(_Out_writes_bytes_(memSize) void* mem, int memSize, hkBool isString=false);

#ifndef __HAVOK_PARSER__
        /// The havok parser produces a template instantiation record definition
        /// when it finds an implicit instantiation such as in this constructor.
        /// In order to do that, it needs to have already encountered the complete
        /// definition of the template class itself. As this function might be
        /// encountered before the hkArray template definition, we need to skip it
        /// with the Havok parser.

            /// Create an ostream connected to a growable memory buffer.
            /// The buffer must exist for the lifetime of this object.
        explicit hkOstream( hkArray<char, hkContainerHeapAllocator>& buf );
#endif

            /// Create an ostream connected to a memory track.
            /// The buffer must exist for the lifetime of this object.
        explicit hkOstream(_Inout_ hkMemoryTrack* track );

            /// Destroys the stream.
        virtual ~hkOstream();

            /// Checks the error status of the stream.
        hkBool isOk() const;

            /// Outputs a hex address.
        hkOstream& operator<< (_In_opt_ const void* p);

            /// Outputs a hkBool.
        hkOstream& operator<< (hkBool b);

            /// Outputs a char.
        hkOstream& operator<< (char c);

            /// Outputs a signed char.
        hkOstream& operator<< (signed char c);

            /// Outputs an unsigned char.
        hkOstream& operator<< (unsigned char c);

            /// Outputs a string.
        hkOstream& operator<< (_In_z_ const char* s);

            /// Outputs a string.
        hkOstream& operator<< (_In_z_ const signed char* s);

            /// Outputs a string.
        hkOstream& operator<< (_In_z_ const unsigned char* s);

            /// Outputs a short.
        hkOstream& operator<< (short s);

            /// Outputs an unsigned short
        hkOstream& operator<< (unsigned short s);

            /// Outputs an int
        hkOstream& operator<< (int i);

            /// Outputs an unsigned int.
        hkOstream& operator<< (unsigned int u);

            /// Outputs a signed long
        hkOstream& operator<< (signed long i);

            /// Outputs an unsigned long
        hkOstream& operator<< (unsigned long u);

            /// Outputs a signed long long
        hkOstream& operator<< (signed long long i);

            /// Outputs an unsigned long long
        hkOstream& operator<< (unsigned long long u);

            /// Outputs a float.
        hkOstream& operator<< (float f);

            /// Outputs a double.
        hkOstream& operator<< (double d);

        hkOstream& operator<< (const hkSimdFloat32& v);
        hkOstream& operator<< (const hkVector4f& v);
        hkOstream& operator<< (const hkQuaternionf& q);
        hkOstream& operator<< (const hkMatrix3f& v);
        //hkOstream& operator<< (const hkMatrix4f& v);
        hkOstream& operator<< (const hkTransformf& v);
        hkOstream& operator<< (const hkSimdDouble64& v);
        hkOstream& operator<< (const hkVector4d& v);
        hkOstream& operator<< (const hkQuaterniond& q);
        hkOstream& operator<< (const hkMatrix3d& v);
        //hkOstream& operator<< (const hkMatrix4d& v);
        hkOstream& operator<< (const hkTransformd& v);

            /// Outputs an hkString.
        hkOstream& operator<< (const hkStringPtr& str);

            /// Outputs an hkString.
        hkOstream& operator<< (const hkStringBuf& str);

            /// Outputs an hkString.
        hkOstream& operator<< (const hkStringView str);

            /// Custom output.
        hkOstream& operator<< (const CustomFormater& custom) { custom.writeTo(*this); return *this; }

            /// Outputs raw data.
            int write(_In_reads_(nbytes) const char* buf, int nbytes);

            /// Outputs formatted data.
        void printf(_Printf_format_string_ const char *fmt, ...);

            /// Flushes printf stream.
        void flush();

            /// Returns the underlying hkStreamWriter used by this hkOstream.
        _Ret_maybenull_ hkStreamWriter* getStreamWriter();

            /// Set the underlying hkStreamWriter for this hkOstream
        void setStreamWriter(_In_ hkStreamWriter* newWriter);

    protected:

        hkRefPtr<hkStreamWriter> m_writer;
};

typedef hkOstream hkOfstream;

#include <Common/Base/System/Io/OStream/hkOStream.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
