// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Common/Base/Container/String/hkStringBuf.h>

#include <Common/Base/Fwd/hkcstdarg.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Base/System/Io/Writer/Buffered/hkBufferedStreamWriter.h>

using namespace std;

static const int HK_BUFSIZ = 10024;

static void HK_CALL writeString(_Inout_ hkStreamWriter* sb, _In_opt_z_ const char* s)
{
    if(s)
    {
        sb->write( s, hkString::strLen(s) );
    }
    else
    {
        sb->write( "(null)", 6);
    }
}


hkOstream::hkOstream(_In_ hkStreamWriter* sw)
    :   m_writer(sw)
{
}

hkOstream::hkOstream(_In_z_ const char* filename)
{
    m_writer = hkFileSystem::getInstance().openWriter(filename);
}

hkOstream::hkOstream(_Out_writes_bytes_(memSize) void* mem, int memSize, hkBool isString)
{
    m_writer.setAndDontIncrementRefCount( new hkBufferedStreamWriter(mem, memSize, isString) );
}

hkOstream::hkOstream( hkArray<char, hkContainerHeapAllocator>& buf )
{
    m_writer.setAndDontIncrementRefCount( new hkArrayStreamWriter(&buf, hkArrayStreamWriter::ARRAY_BORROW) );
}

hkOstream::hkOstream(_Inout_ hkMemoryTrack* buf)
{
    m_writer.setAndDontIncrementRefCount( new hkMemoryTrackStreamWriter( buf, hkMemoryTrackStreamWriter::TRACK_BORROW ) );
}


hkOstream::~hkOstream()
{
}

hkBool hkOstream::isOk() const
{
    return m_writer && m_writer->isOk();
}

hkOstream& hkOstream::operator<< (_In_opt_ const void* p)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%p", p);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (hkBool b)
{
    writeString(m_writer, b ? "true" : "false" );
    return *this;
}

hkOstream& hkOstream::operator<< (char c)
{
    m_writer->write(&c, 1);
    return *this;
}

hkOstream& hkOstream::operator<< (const char* s)
{
    writeString(m_writer, s);
    return *this;
}

hkOstream& hkOstream::operator<< (short s)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%i", s);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (unsigned short s)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%u", s);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (int i)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%i", i);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (unsigned int u)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%u", u);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (const hkSimdFloat32& f)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%f", f.getReal());
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (const hkSimdDouble64& f)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%f", f.getReal());
    writeString(m_writer, buf);
    return *this;
}


hkOstream& hkOstream::operator<< (float f)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, "%f", f);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (signed long i)
{
    const char* fmt = sizeof(long)==sizeof(hkInt64) ? HK_PRINTF_FORMAT_INT64 : "%i";
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, fmt, i);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (unsigned long u)
{
    const char* fmt = sizeof(long)==sizeof(hkUint64) ? HK_PRINTF_FORMAT_UINT64 : "%u";
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, fmt, u);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (signed long long i)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, HK_PRINTF_FORMAT_INT64, i);
    writeString(m_writer, buf);
    return *this;
}

hkOstream& hkOstream::operator<< (unsigned long long u)
{
    char buf[HK_BUFSIZ];
    hkString::snPrintf(buf, HK_BUFSIZ, HK_BUFSIZ, HK_PRINTF_FORMAT_UINT64, u);
    writeString(m_writer, buf);
    return *this;
}

hkOstream&  hkOstream::operator<< (const hkVector4f& v)
{
    this->printf("[%g,%g,%g,%g]", v(0), v(1), v(2), v(3));
    return *this;
}

hkOstream&  hkOstream::operator<< (const hkVector4d& v)
{
    this->printf("[%g,%g,%g,%g]", v(0), v(1), v(2), v(3));
    return *this;
}



hkOstream&  hkOstream::operator<< (const hkQuaternionf& q)
{
    this->printf("[%f,%f,%f,(%f)]", q.m_vec(0), q.m_vec(1), q.m_vec(2), q.m_vec(3));
    return *this;
}

hkOstream&  hkOstream::operator<< (const hkQuaterniond& q)
{
    this->printf("[%f,%f,%f,(%f)]", q.m_vec(0), q.m_vec(1), q.m_vec(2), q.m_vec(3));
    return *this;
}

hkOstream&  hkOstream::operator<< (const hkMatrix3f& m)
{
    for( int i=0; i<3; ++i)
    {
        this->printf("|%f,%f,%f|\n", m(i,0), m(i,1), m(i,2) );
    }
    return *this;
}

#if 0
hkOstream&  hkOstream::operator<< (const hkMatrix4f& m)
{
    for( int i=0; i<4; ++i)
    {
        this->printf("|%f,%f,%f,%f|\n", m(i,0), m(i,1), m(i,2), m(i,3) );
    }
    return *this;
}
#endif

hkOstream&  hkOstream::operator<< (const hkMatrix3d& m)
{
    for( int i=0; i<3; ++i)
    {
        this->printf("|%f,%f,%f|\n", m(i,0), m(i,1), m(i,2) );
    }
    return *this;
}

// hkOstream&  hkOstream::operator<< (const hkMatrix4d& m)
// {
//  for( int i=0; i<4; ++i)
//  {
//      this->printf("|%f,%f,%f,%f|\n", m(i,0), m(i,1), m(i,2), m(i,3) );
//  }
//  return *this;
// }

hkOstream&  hkOstream::operator<< (const hkTransformf& t)
{
    return (*this) << t.getRotation() << t.getTranslation();
}

hkOstream&  hkOstream::operator<< (const hkTransformd& t)
{
    return (*this) << t.getRotation() << t.getTranslation();
}



void hkOstream::printf(_Printf_format_string_ const char *fmt, ...)
{
    char buf[HK_BUFSIZ];
    va_list args;
    va_start(args, fmt);
    hkString::vsnPrintf(buf, HK_BUFSIZ, fmt, args);
    va_end(args);
    writeString(m_writer, buf);
}

hkOstream& hkOstream::operator<< (const hkStringPtr& str)
{
    if (str.cString())
    {
        m_writer->write( str.cString(), str.getLength() );
    }
    else
    {
        m_writer->write( "(null)", 6 );
    }
    return *this;
}

hkOstream& hkOstream::operator<< (const hkStringBuf& str)
{
    if (str.cString())
    {
        m_writer->write( str.cString(), str.getLength() );
    }
    else
    {
        m_writer->write( "(null)", 6 );
    }
    return *this;
}

hkOstream& hkOstream::operator<< (const hkStringView str)
{
    if (str.begin())
    {
        m_writer->write(str.begin(), str.getSize());
    }
    else
    {
        m_writer->write("(null)", 6);
    }
    return *this;
}

void hkOstream::flush()
{
    m_writer->flush();
}

// Output raw data.
int hkOstream::write(_In_reads_(nbytes) const char* buf, int nbytes)
{
    return m_writer->write(buf, nbytes);
}

void hkOstream::setStreamWriter(_In_ hkStreamWriter* newWriter)
{
    m_writer = newWriter;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
