// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#define READ_SINGLE(TYPE) TYPE t; readArrayGeneric(&t, sizeof(TYPE), 1); return t

HK_INLINE hkChar hkIArchive::read8()
{
    READ_SINGLE(hkChar);
}

HK_INLINE hkUchar hkIArchive::read8u()
{
    READ_SINGLE(hkUchar);
}

HK_INLINE hkInt16 hkIArchive::read16()
{
    READ_SINGLE(hkInt16);
}

HK_INLINE hkUint16 hkIArchive::read16u()
{
    READ_SINGLE(hkUint16);
}

HK_INLINE hkInt32 hkIArchive::read32()
{
    READ_SINGLE(hkInt32);
}

HK_INLINE hkUint32 hkIArchive::read32u()
{
    READ_SINGLE(hkUint32);
}

HK_INLINE hkInt64 hkIArchive::read64()
{
    READ_SINGLE(hkInt64);
}

HK_INLINE hkUint64 hkIArchive::read64u()
{
    READ_SINGLE(hkUint64);
}

HK_INLINE hkFloat32 hkIArchive::readFloat32()
{
    READ_SINGLE(hkFloat32);
}

HK_INLINE hkDouble64 hkIArchive::readDouble64()
{
    READ_SINGLE(hkDouble64);
}

#undef READ_SINGLE

HK_INLINE void hkIArchive::readArray8(_Out_writes_(nelem) hkInt8* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkInt8), nelem);
}

HK_INLINE void hkIArchive::readArray8u(_Out_writes_(nelem) hkUint8* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkUint8), nelem);
}

HK_INLINE void hkIArchive::readArray16(_Out_writes_(nelem) hkInt16* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkInt16), nelem);
}

HK_INLINE void hkIArchive::readArray16u(_Out_writes_(nelem) hkUint16* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkUint16), nelem);
}

HK_INLINE void hkIArchive::readArray32(_Out_writes_(nelem) hkInt32* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkInt32), nelem);
}

HK_INLINE void hkIArchive::readArray32u(_Out_writes_(nelem) hkUint32* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkUint32), nelem);
}

HK_INLINE void hkIArchive::readArray64(_Out_writes_(nelem) hkInt64* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkInt64), nelem);
}

HK_INLINE void hkIArchive::readArray64u(_Out_writes_(nelem) hkUint64* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkUint64), nelem);
}

HK_INLINE void hkIArchive::readArrayFloat32(_Out_writes_(nelem) hkFloat32* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkFloat32), nelem);
}

HK_INLINE void hkIArchive::readArrayDouble32u(_Out_writes_(nelem) hkDouble64* buf, int nelem)
{
    readArrayGeneric(buf, sizeof(hkDouble64), nelem);
}

HK_INLINE void hkIArchive::setByteSwap(hkBool onoff)
{
    m_byteSwap = onoff;
}

HK_INLINE hkBool hkIArchive::getByteSwap() const
{
    return m_byteSwap;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
