// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <Common/Base/System/Io/IArchive/hkIArchive.h>
#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>

hkIArchive::hkIArchive(_In_ hkStreamReader* sb, bool bs)
    :   m_streamReader(sb), m_byteSwap(bs)
{
}

hkIArchive::hkIArchive(_In_z_ const char* filename, bool bs)
    : m_byteSwap(bs)
{
    m_streamReader = hkFileSystem::getInstance().openReader(filename);
}

hkIArchive::hkIArchive(_In_reads_bytes_(memSize) const void* mem, int memSize, bool byteswap)
    : m_byteSwap(byteswap)
{
    m_streamReader.setAndDontIncrementRefCount( new hkMemoryStreamReader(mem, memSize, hkMemoryStreamReader::MEMORY_INPLACE) );
}

hkIArchive::~hkIArchive()
{
}

static HK_INLINE void byteswap(char& a, char& b)
{
    char t = a;
    a = b;
    b = t;
}

int hkIArchive::readString( _Out_writes_z_(bufSize) char* buf, int bufSize )
{
    int count = 0;
    if ( bufSize > 0 )
    {
        buf--;
        do
        {
            buf++;
            ( *buf ) = read8();
            count++;
        } while ( ( *buf != '\0' ) && ( count < bufSize ) );
    }
    return count;
}

int hkIArchive::readString(hkStringBuf& buf)
{
    buf.clear();
    char cbuf[128];
    int read;
    do
    {
        read = readString( cbuf, sizeof( cbuf ) );
        buf.append( cbuf, read );
    } while ( read == sizeof( cbuf ) );
    return buf.getLength();
}

void hkIArchive::readArrayFloat32(_Out_writes_(nelem) hkDouble64* buf, int nelem)
{
    for (int i =0; i < nelem; i++)
    {
        hkFloat32 d = readFloat32();
        buf[i] = d;
    }
}

void hkIArchive::readArrayGeneric(_Out_writes_bytes_(arraySize * elemsize) void* array, int elemsize, int arraySize)
{
    int nreq = elemsize * arraySize;
    HK_ON_DEBUG_SLOW( int nread = ) m_streamReader->read(array, nreq);
#ifdef HK_DEBUG_SLOW
    if ( nreq != nread )
    {
        // Failed read: write whole array with 0xffs.
        for ( int i = 0; i < elemsize * arraySize; ++i )
        {
            hkUchar* dst = static_cast<hkUchar*>(array);
            dst[i] = 0xff;
        }
    }
    else
#endif // HK_DEBUG_SLOW
    if ( m_byteSwap )
    {
        char* dst = static_cast<char*>(array);
        switch( elemsize )
        {
            case 1:
            {
                break;
            }
            case 2:
            {
                for(int i = 0; i < arraySize; ++i)
                {
                    byteswap(dst[0], dst[1]);
                    dst += 2;
                }
                break;
            }
            case 4:
            {
                for(int i = 0; i < arraySize; ++i)
                {
                    byteswap(dst[0], dst[3]);
                    byteswap(dst[1], dst[2]);
                    dst += 4;
                }
                break;
            }
            case 8:
            {
                for(int i = 0; i < arraySize; ++i)
                {
                    byteswap(dst[0], dst[7]);
                    byteswap(dst[1], dst[6]);
                    byteswap(dst[2], dst[5]);
                    byteswap(dst[3], dst[4]);
                    dst += 8;
                }
                break;
            }
            default:
            {
                HK_ASSERTV(0x3d71710d, 0, "elemsize {} not handled.\n"
                    "elemsize must be a power of two and no greater than 8 (64 bits).", elemsize);

            }
        }
    }
}

int hkIArchive::readRaw(_Out_writes_bytes_(nbytes) void* buf, int nbytes)
{
    return m_streamReader->read(buf, nbytes);
}

hkBool hkIArchive::isOk() const
{
    return m_streamReader && m_streamReader->isOk();
}

_Ret_maybenull_ hkStreamReader* hkIArchive::getStreamReader()
{
    return m_streamReader;
}

void hkIArchive::setStreamReader(_In_ hkStreamReader* newBuf)
{
    m_streamReader = newBuf;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
