// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

#if defined(HK_PLATFORM_WINRT)
    #include <Common/Base/System/Io/Platform/WinRT/hkWinRTFileSystem.h>
    typedef hkWinRTFileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_WIN32)
    #include <Common/Base/System/Io/Platform/Win32/hkWin32FileSystem.h>
    typedef hkWin32FileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_PSVITA)
    #include <Common/Base/System/Io/Platform/PsVita/hkPsVitaFileSystem.h>
    typedef hkPsVitaFileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_ANDROID)
    #include <Common/Base/System/Io/Platform/Android/hkAndroidAssetManagerFileSystem.h>
    typedef hkAndroidAssetManagerFileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_TIZEN)
    #include <Common/Base/System/Io/Platform/Posix/hkPosixFileSystem.h>
    typedef hkPosixFileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_WIIU)
    #include <Common/Base/System/Io/Platform/WiiU/hkWiiuFileSystem.h>
    typedef hkWiiuFileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_PS4)
    #include <Common/Base/System/Io/Platform/Ps4/hkPs4FileSystem.h>
    typedef hkPs4FileSystem hkNativeFileSystem;
#elif defined(HK_PLATFORM_NX)
    #include <Common/Base/System/Io/Platform/Nx/hkNxFileSystem.h>
    typedef hkNxFileSystem hkNativeFileSystem;
#else
    #error nofs
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
