// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>

class hkStreamReader;
class hkStreamWriter;


namespace hkFileSystemCallback
{
    // For the compress function, the cbData parameter must be an array of file extensions for the file types that can/should be compressed.
    // This callback data is the sole way in which the compress function determines whether to return a compressed stream writer.
    typedef hkArrayView<const char*> CompressCbData;

    hkResult compress(_Inout_ hkRefPtr<hkStreamWriter>& orig, _In_z_ const char* path, hkFileSystem::OpenFlags flags, _In_opt_ void* cbData);

    // Compressed files are automatically detected based on the magic numbers in the header, so no callback data is required here.
    hkResult decompress(_Inout_ hkRefPtr<hkStreamReader>& orig, _In_z_ const char* path, hkFileSystem::OpenFlags flags, _In_opt_ void* cbData);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
