// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/FileSystem/Util/hkFileSystemCallbacks.h>
#include <Common/Base/System/Io/Reader/Compressed/hkCompressedStreamReader.h>
#include <Common/Base/System/Io/Writer/Compressed/hkCompressedStreamWriter.h>

#define DEBUG_LOG_IDENTIFIER "io.FileSystemCallbacks"
#include <Common/Base/System/Log/hkLog.hxx>

hkResult hkFileSystemCallback::compress(_Inout_ hkRefPtr<hkStreamWriter>& orig, _In_z_ const char* path, hkFileSystem::OpenFlags flags, _In_opt_ void* cbData)
{
    if (cbData)
    {
        // Check file extension for compressible file type
        CompressCbData* extensions = static_cast<CompressCbData*>(cbData);
        if (hkString::endsWithAnyCase(path, *extensions))
        {
            orig = hkAutoRemoveReference(new hkCompressedStreamWriter(orig, orig->seekTellSupported()));
        }
    }
    else
    {
        Log_Info("No file compression will occur if the compress callback was registered without callback data.");
    }
    return HK_SUCCESS;
}

hkResult hkFileSystemCallback::decompress(_Inout_ hkRefPtr<hkStreamReader>& orig, _In_z_ const char* path, hkFileSystem::OpenFlags flags, _In_opt_ void* cbData)
{
    return hkCompressedStreamReader::make(orig);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
