// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkSeekableStreamReader;
class hkSocket;
class hkFileSystem;

class HK_EXPORT_COMMON hkFileServer
{
public:
    HK_DECLARE_CLASS(hkFileServer, NoNew);

    enum ReturnCode
    {
            // Socket was closed gracefully on client side
        RETURN_SOCKET_CLOSED = 0,

            // Socket was closed for unknown reason on client side
        RETURN_SOCKET_ERROR,

            // Server was stopped on server
        RETURN_SERVER_SHUTDOWN,
    };

    struct OpenReadFiles
    {
        HK_DECLARE_CLASS(OpenReadFiles, New);

        hkUint32 id;
        hkRefPtr<hkSeekableStreamReader> s;
        hkUint32 bytesReadTotal;
        hkStringPtr filename;
    };

    struct OpenWriteFiles
    {
        HK_DECLARE_CLASS(OpenWriteFiles, New);

        hkUint32 id;
        hkRefPtr<hkStreamWriter> s;
        hkUint32 bytesWrittenTotal;
        hkStringPtr filename;
    };

    typedef void (HK_CALL *ProgressReportFunction)(_In_z_ const char* filename, int progress, _In_z_ const char* info);

    struct HK_EXPORT_COMMON ThreadData
    {
        HK_DECLARE_CLASS(ThreadData, New);

        ThreadData();

        hkRefPtr<hkFileSystem> m_fileSystem;
        hkCriticalSection* m_dataLock;
        bool m_requestShutdown;
        bool m_nonBlocking;
        hkStringPtr m_rootDir;
        hkSocket* m_socket;
        ProgressReportFunction m_progressFunc;
    };

    static ReturnCode serve(_Inout_ ThreadData* threadData);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
