// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/FileSystem/hkNativeFileSystem.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

class HK_EXPORT_COMMON hkServerFileSystem : public hkFileSystem
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

        static _Ret_notnull_ hkReferencedObject* create(int port=0)
        {
            return new hkServerFileSystem(port);
        }

        static int getDefaultPort();

        virtual hkResult remove(_In_z_ const char* path) HK_OVERRIDE;

        // Will only return success or failure, never a specific error code, such as HK_E_ALREADY_EXISTS, as is the case for other file systems.
        virtual hkResult mkdir(_In_z_ const char* path, CreateFlag flag) HK_OVERRIDE;

        virtual hkResult stat(_In_z_ const char* path, Entry& entryOut ) HK_OVERRIDE;

        virtual _Ret_z_ const char* getOperatingSystemPath(_In_z_ const char* pathIn, hkStringBuf& pathOut, OSPathFlags flags ) HK_OVERRIDE;

        virtual hkRefNew<Watcher> createWatcher(_In_z_ const char* topDirectory) HK_OVERRIDE;

        virtual hkRefNew<Iterator::Impl> createIterator(_In_z_ const char* top, _In_z_ const char* wildcard ) HK_OVERRIDE;

        // Default = VIRTUAL_READWRITE | WAIT_FOR_CONNECT
        enum Mode
        {
            VIRTUAL_READ = 1,
            VIRTUAL_WRITE = 2,
            VIRTUAL_READWRITE = (VIRTUAL_READ | VIRTUAL_WRITE),

            VIRTUAL_DIRLIST = 4,

            WAIT_FOR_CONNECT = 8, // Connect from server
            WAIT_FOR_CONNECT_TO_SERVER = 16, // // Connect to server

            DEFAULT = (VIRTUAL_READWRITE | VIRTUAL_DIRLIST | WAIT_FOR_CONNECT)
        };

        enum Version
        {
            CUR_VERSION = 0x00010000,
            MIN_COMPAT_VERSION = 0x00010000
        };

        enum OutCommands
        {
            FILE_READ = 0x01,
            FILE_WRITE = 0x02,
            DIR_LIST = 0x03,
            FILE_STAT = 0x04,
            SHUT_DOWN = 0x05,
            REMOVE = 0x06,
            MKDIR = 0x07,
            WATCH = 0x08,
            UNWATCH = 0x09,
            CHANGES = 0x0A,
        };

        enum InCommands
        {
            NOT_FOUND = 0x01,
            SEND_DIR_LIST = 0x02,
            SEND_STAT = 0x03,
            SEND_CHANGES = 0x04,
            ACK = 0xAC
        };

        void setMode( Mode m );
        void shutdown();
        void closeConnection();
        bool waitForConnection();
        bool tryForConnection();

        void removeWatcher(hkUint32 id);
        hkResult getCompletedChanges(hkUint32 id, hkArray<Watcher::Change>& changesOut);

        void setLocalPathPrefix(_In_z_ const char* prefix) { m_localPathPrefix = prefix; }

        void setServerAddress(_In_z_ const char* addr);

    public:

        hkServerFileSystem(int port=0);
        virtual ~hkServerFileSystem();

    protected:

        virtual hkRefNew<hkStreamReader> _openReader(_In_z_ const char* name, OpenFlags flags) HK_OVERRIDE;
        virtual hkRefNew<hkStreamWriter> _openWriter(_In_z_ const char* name, OpenFlags flags) HK_OVERRIDE;

        hkResult removeOrMkdir(_In_z_ const char* path, OutCommands command );

        Mode m_mode;
        int m_connectionPort;
        class hkSocket* m_listenSocket;
        class hkSocket* m_connectSocket;
        hkStringPtr m_localPathPrefix;

        // for WAIT_FOR_CONNECT_TO_SERVER mode
        hkStringPtr m_serverAddress;

        hkCriticalSection m_connectionLock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
