// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkSocket;
class hkCriticalSection;
class HK_EXPORT_COMMON hkFileServerStreamWriter : public hkStreamWriter
{

public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

    hkFileServerStreamWriter (_In_ hkSocket* connection, hkUint32 m_id, _In_ hkCriticalSection* socketLock );
    void close();
    virtual ~hkFileServerStreamWriter ();
    virtual _Ret_range_(0, nbytes) int write(_In_reads_bytes_(nbytes) const void* buf, int nbytes);
    virtual void flush();
    virtual hkBool isOk() const;

    virtual hkBool seekTellSupported() const;
    virtual hkResult seek(int offset, SeekWhence whence);
    virtual int tell() const;

    enum OutCommands
    {
        WRITE_CHUNK = 0x21,
        CLOSE = 0x22,
        SEEK = 0x23,
        TELL = 0x24,
        FLUSH = 0x25,
    };

    enum InCommands
    {
        WROTE = 0x21,
        SEND_TELL = 0x22,
        IN_ERROR = 0x23
    };

    hkSocket* m_socket;
    hkUint32 m_id;
    class hkCriticalSection* m_socketLock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
