// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

class hkSocket;
class hkCriticalSection;
class HK_EXPORT_COMMON hkFileServerStreamReader : public hkSeekableStreamReader
{

public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_STREAM);

    hkFileServerStreamReader(_In_ hkSocket* connection, hkUint32 id, _In_ hkCriticalSection* socketLock );
    void close();
    virtual ~hkFileServerStreamReader();
    virtual _Ret_range_(0, nbytes) int read(_Out_writes_bytes_(nbytes) void* buf, int nbytes);
    virtual hkBool isOk() const;

    virtual hkResult seek(int offset, SeekWhence whence);
    virtual int tell() const;

    enum OutCommands
    {
        READ_CHUNK = 0x11,
        CLOSE = 0x12,
        // Use Seek and Tell sparingly..
        SEEK = 0x13,
        TELL = 0x14,
        IS_OK = 0x15,
    };

    enum InCommands
    {
        SEND_CHUNK = 0x11,
        EOF_OR_ERROR = 0x12,
        SEND_TELL = 0x13
    };

    hkSocket* m_socket;
    hkUint32 m_id;
    hkBool m_isAtEof;
    hkCriticalSection* m_socketLock;

protected:
    hkBool remoteReaderIsOk() const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
