// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Include Source/Common/Base/System/Init/PlatformInit.cxx once, and only once, in your solution to define the symbols
// .cxx schematic is used instead of normal .cpp to prevent this symbol from being present in hkBase.lib
// PlatformInit and other symbols are only defined in the final .exe if and only if they are used.

// Platform specific initialization required before initializing Havok's memory system.
// This file is meant to be used in stand-alone demos as the demo framework's platform
// initialization functions sometimes depend on the graphics system (e.g Wii, see
// PlatformInitWii.cpp and hkgSystemGCN.cpp)

class hkFileSystem;
class hkUnionFileSystem;

void PlatformInit();
void PlatformQuit();
void PlatformAddDefaultMounts( _Inout_ hkFileSystem* basefs, _Inout_ hkUnionFileSystem* ufs );
void PlatformFileSystemInit();

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
