// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/System/Init/PlatformInit.h>

// Include this file once, and only once, in your solution to define the symbols
// .cxx schematic is used instead of normal .cpp to prevent this symbol from being present in hkBase.lib
// PlatformInit and other symbols are only defined in the final .exe if and only if they are used.
// Include Source/Common/Base/System/Init/PlatformInit.h instead for declaration

#include <Common/Base/System/Io/FileSystem/Union/hkUnionFileSystem.h>
#include <Common/Base/Config/hkConfigSimd.h>

#if defined(HK_PLATFORM_PS4)
#   include <emmintrin.h>
#elif defined(HK_COMPILER_HAS_INTRINSICS_IA32)
#   if defined(HK_COMPILER_MSVC)
#       include <intrin.h>
#   else
#       include <xmmintrin.h>
#   endif
#endif

#if   defined(HK_PLATFORM_ANDROID)
    #include <Common/Base/System/Init/PlatformInitAndroid.cxx>
#elif defined(HK_PLATFORM_IOS)
    #include <Common/Base/System/Init/PlatformInitIOS.hxx>
#elif defined(HK_PLATFORM_MAC)
    #include <Common/Base/System/Init/PlatformInitMac.cxx>
#elif defined(HK_PLATFORM_PS4)
    #include <Common/Base/System/Init/PlatformInitPs4.cxx>
#elif defined(HK_PLATFORM_WIIU)
    #include <Common/Base/System/Init/PlatformInitWiiU.cxx>
#elif defined(HK_PLATFORM_WINRT)
    #include <Common/Base/System/Init/PlatformInitWinRT.cxx>
#elif defined(HK_PLATFORM_NX)
    #include <Common/Base/System/Init/PlatformInitNx.cxx>
#else
    // Perform no setup by default
    void PlatformInit()
    {
    
#   if defined(HK_COMPILER_HAS_INTRINSICS_IA32)
#      if !( defined(HK_PLATFORM_LINUX) && !defined(HK_ARCH_X64) && HK_CONFIG_SIMD == HK_CONFIG_SIMD_DISABLED )  // Not Linux32 FPU
        // Flush all denormal/subnormal numbers (2^-1074 to 2^-1022) to zero.
        // Typically operations on denormals are very slow, up to 100 times slower than normal numbers.
        _MM_SET_FLUSH_ZERO_MODE( _MM_FLUSH_ZERO_ON );
#      endif
#   endif
    
    }
    void PlatformQuit()
    {}
    void PlatformAddDefaultMounts(_Inout_ hkFileSystem* basefs, _Inout_ hkUnionFileSystem* ufs)
    {
        ufs->mount(basefs, "", "", true);
    }
#endif

void PlatformFileSystemInit()
{
    hkFileSystem* basefs =  &hkFileSystem::getInstance();
    hkUnionFileSystem* ufs = new hkUnionFileSystem();
    PlatformAddDefaultMounts(basefs, ufs);
    hkFileSystem::replaceInstance(ufs);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
