// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//HK_REFLECTION_PARSER_EXCLUDE_FILE
#pragma once

#include <Common/Base/System/Error/hkError.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>

namespace hkTest
{
    struct TestStatementBase;
}

// C4611 interaction between '_setjmp' and C++ object destruction is non-portable yes we know.
HK_DETAIL_DIAG_MSVC_PUSH()
HK_DETAIL_DIAG_MSVC_OFF(4611)

/// Error handler used to filter a specific error message, optionally transferring execution to a given jump location.
/// Messages are optionally forwarded to the previously installed error handler.
class HK_EXPORT_COMMON hkFilterError : public hkError
{
    //+hk.MemoryTracker(ignore=True)
public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

    hkFilterError( bool fwdFilteredMessage = false, bool fwdOtherMessages = true  ) : m_prevHandler(HK_NULL), m_fwdFilteredMessage(fwdFilteredMessage), m_fwdOtherMessages(fwdOtherMessages) {}

    /// Executes the given test statement, checking that the specified message has been raised
    /// Abort the statement when the message is raised
    void checkMessage(Message m, int id, _Inout_ hkTest::TestStatementBase* statement);
    /// Executes the test statement, checking that the specified message has been raised
    /// Continue execution after the message
    void checkMessageAndContinue(Message m, int id, _Inout_ hkTest::TestStatementBase* statement);

    /// Returns whether or not the message in question has been raised
    hkBool wasMessageRaised() const { return m_messageRaised; }

    /// Return value indicates whether or not to trigger an HK_BREAKPOINT for errors and asserts.
    virtual int message(Message m, int id, _In_z_ const char* description, _In_z_ const char* file, int line);

    /// Enables/disables diagnostic by id.
    virtual void setEnabled(int id, hkBool enabled);

    /// Enables/disables diagnostic by id.
    virtual hkBool isEnabled(int id);

    /// Force all diagnostics to be enabled.
    virtual void enableAll();

    /// Begin a new report section
    virtual void sectionBegin(int id, _In_z_ const char* sectionName);

    /// End the current report section
    virtual void sectionEnd();

private:

    hkError* m_prevHandler;
    void* m_jumpBuffer;
    Message m_message;
    int m_id;
    hkBool m_messageRaised;
    hkBool m_fwdFilteredMessage;
    hkBool m_fwdOtherMessages;
};

HK_DETAIL_DIAG_MSVC_POP()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
