// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Fwd/hkcstring.h>
#include <Common/Base/System/Error/hkFilterError.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

#if defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS) || (defined(HK_PLATFORM_NX) && !defined(HK_PLATFORM_NX_WIN32) && !defined(HK_PLATFORM_NX_X64))
#include <setjmp.h>
#endif

// C4611 interaction between '_setjmp' and C++ object destruction is non-portable
HK_DETAIL_DIAG_MSVC_PUSH()
HK_DETAIL_DIAG_MSVC_OFF(4611)

void hkFilterError::checkMessage(Message m, int id, _Inout_ hkTest::TestStatementBase* fn)
{
    if (m_prevHandler != HK_NULL) return;
    m_prevHandler = &hkError::getInstance();
    m_prevHandler->addReference();
    hkError::replaceInstanceAndAddReference(this);

    m_message = m;
    m_id = id;
    HK_STD_NAMESPACE::jmp_buf jump_buffer;
    m_jumpBuffer = jump_buffer;

    m_messageRaised = false;
    if (HK_STD_NAMESPACE::setjmp(jump_buffer) == 0)
    {
        fn->testMe();
    }

    if (m_prevHandler != HK_NULL)
    {
        hkError::replaceInstanceAndAddReference(m_prevHandler);
        m_prevHandler->removeReference();
    }
}

void hkFilterError::checkMessageAndContinue(Message m, int id, _Inout_ hkTest::TestStatementBase* fn)
{
    if (m_prevHandler != HK_NULL) return;
    m_prevHandler = &hkError::getInstance();
    m_prevHandler->addReference();
    hkError::replaceInstanceAndAddReference(this);

    m_message = m;
    m_id = id;
    m_jumpBuffer = HK_NULL;

    m_messageRaised = false;
    fn->testMe();

    if (m_prevHandler != HK_NULL)
    {
        hkError::replaceInstanceAndAddReference(m_prevHandler);
        m_prevHandler->removeReference();
    }
}

int hkFilterError::message(Message m, int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    if ((m == m_message) && (id == m_id))
    {
        m_messageRaised = true;

#if !defined(HK_PLATFORM_CTR)
        if ( m_jumpBuffer )
        {
            HK_STD_NAMESPACE::longjmp(*reinterpret_cast<HK_STD_NAMESPACE::jmp_buf*>(m_jumpBuffer), 1);
        }
#endif

        if (m_fwdFilteredMessage)
        {
            return m_prevHandler->message(m, id, description, file, line);
        }
        else
        {
            return 0;
        }
    }

    if (m_fwdOtherMessages)
    {
        return m_prevHandler->message(m, id, description, file, line);
    }
    else
    {
        return 0;
    }
}

void hkFilterError::setEnabled(int id, hkBool enabled)
{
    m_prevHandler->setEnabled(id, enabled);
}

hkBool hkFilterError::isEnabled(int id)
{
    return m_prevHandler->isEnabled(id);
}

void hkFilterError::enableAll()
{
    m_prevHandler->enableAll();
}

void hkFilterError::sectionBegin(int id, _In_z_ const char* sectionName)
{
    m_prevHandler->sectionBegin(id, sectionName);
}

void hkFilterError::sectionEnd()
{
    m_prevHandler->sectionEnd();
}

HK_DETAIL_DIAG_MSVC_POP()

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
