// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Error/hkDefaultError.h>

class HK_EXPORT_COMMON hkErrorRouter : public hkError
{
    public:

        HK_DECLARE_CLASS( hkErrorRouter, New, Singleton);

        hkErrorRouter();
        virtual ~hkErrorRouter();

        void addHandler(hkError* errorHandler);
        void removeHandler(hkError* errorHandler );

    public:

        virtual int message(hkError::Message msg, int id, const char* description, const char* file, int line) HK_OVERRIDE;

        virtual void setEnabled( int id, hkBool enabled ) HK_OVERRIDE;
        virtual hkBool isEnabled( int id ) HK_OVERRIDE;
        virtual void enableAll() HK_OVERRIDE;

    protected:

        // List of registered error handlers
        hkArray< hkRefPtr<hkError> > m_registeredHandlers;

        // Whether a message is currently being handled.  Can't have any messages being output to the network during
        // this time, or they'll get redirected to through this framework again, causing an infinite loop.
        bool m_handlingMessage;

        hkCriticalSection m_errorLock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
