// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Object/hkSingleton.h>
#include <Common/Base/System/Error/hkDefaultError.h>
#include <Common/Base/System/Error/hkErrorRouter.h>

HK_SINGLETON_IMPLEMENTATION(hkErrorRouter);

hkErrorRouter::hkErrorRouter()
{
    m_handlingMessage = false;
}

hkErrorRouter::~hkErrorRouter()
{
    m_registeredHandlers.clear();
}

void hkErrorRouter::addHandler(hkError* errorHandler)
{
    m_registeredHandlers.pushBack( errorHandler );
}

void hkErrorRouter::removeHandler(hkError* errorHandler )
{
    int index = m_registeredHandlers.indexOf( errorHandler );
    if (index >= 0)
    {
        m_registeredHandlers.removeAt(index);
    }
}

int hkErrorRouter::message(hkError::Message msg, int id, const char* description, const char* file, int line)
{
    // Early out if no handlers present
    if ( m_registeredHandlers.getSize() == 0 )
    {
        return 0;
    }

    hkCriticalSectionLock lock( &m_errorLock );

    // Early out if already handling a message.  Must happen after critical section lock.
    if( m_handlingMessage )
    {
        return 0;
    }

    int retVal = 0;
    for (int i = 0; i < m_registeredHandlers.getSize(); i++)
    {
        m_handlingMessage = true;
        retVal = m_registeredHandlers[i]->message(msg, id, description, file, line);
        m_handlingMessage = false;
    }

    // return last error
    return retVal;
}

void hkErrorRouter::setEnabled( int id, hkBool enabled )
{
    return;
}

hkBool hkErrorRouter::isEnabled( int id )
{
    return true;
}

void hkErrorRouter::enableAll()
{
    return;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
