// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkReflect { class Type; }
namespace hkVarArgs {
    namespace Detail {
        template <hkUlong N> struct VarArgsTypeArray;
    }
    typedef const Detail::VarArgsTypeArray<0>* VaTypes;
}

namespace hkErrorFwd
{
    /// Log an informative message.
    HK_EXPORT_COMMON int HK_CALL messageReport(int id, _In_z_ const char* description, _In_z_ const char* file, int line);

    /// Log a warning.
    HK_EXPORT_COMMON int HK_CALL messageWarning(int id, _In_z_ const char* description, _In_z_ const char* file, int line);

    /// Log an assertion failure message.
    HK_EXPORT_COMMON int HK_CALL messageAssert(int id, _In_z_ const char* description, _In_z_ const char* file, int line);

    /// Log an assertion failure message.
    HK_EXPORT_COMMON int HK_CALL messageAssert(int id, _In_z_ const char* cond, _In_z_ const char* file, int line, _In_z_ const char* format, hkVarArgs::VaTypes argTypes, ...);

    /// Log an error message.
    HK_EXPORT_COMMON int HK_CALL messageError(int id, _In_z_ const char* description, _In_z_ const char* file, int line);


    /// Enable or disable a non-fatal message by ID.
    HK_EXPORT_COMMON void HK_CALL setEnabled(int id, bool enabled);

    /// Throw a fatal error and terminate execution.
    /// This message cannot be disabled for security reason.
    HK_EXPORT_COMMON _Analysis_noreturn_ void HK_CALL messageFatalError(int id, _In_z_ const char* description, _In_z_ const char* file, int line);

    /// Throw a fatal error and terminate execution.
    /// This message cannot be disabled for security reason.
    HK_EXPORT_COMMON _Analysis_noreturn_ void HK_CALL messageFatalError(int id, _In_z_ const char* file, int line, _In_z_ const char* format, hkVarArgs::VaTypes argTypes, ...);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
