// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Error/hkErrorRouter.h>
#include <Common/Base/Fwd/hkcstdarg.h>

#if defined(HK_COMPILER_MSVC_VERSION) && (HK_COMPILER_MSVC_VERSION >= 1610) // as per __fastfail() declaration in winnt.h
    #include <Common/Base/Fwd/hkwindows.h> 
#else
    #include <Common/Base/Fwd/hkcstdlib.h>
#endif

int HK_CALL hkErrorFwd::messageReport(int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    hkErrorRouter::getInstance().message(hkError::MESSAGE_REPORT, id, description, file, line);
    return hkError::getInstance().message(hkError::MESSAGE_REPORT, id, description, file, line);
}

int HK_CALL hkErrorFwd::messageWarning(int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    hkErrorRouter::getInstance().message(hkError::MESSAGE_WARNING, id, description, file, line);
    return hkError::getInstance().message(hkError::MESSAGE_WARNING, id, description, file, line);
}

int HK_CALL hkErrorFwd::messageAssert(int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    hkErrorRouter::getInstance().message(hkError::MESSAGE_ASSERT, id, description, file, line);
    return hkError::getInstance().message(hkError::MESSAGE_ASSERT, id, description, file, line);
}

int HK_CALL hkErrorFwd::messageError(int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    hkErrorRouter::getInstance().message(hkError::MESSAGE_ERROR, id, description, file, line);
    return hkError::getInstance().message(hkError::MESSAGE_ERROR, id, description, file, line);
}

int HK_CALL hkErrorFwd::messageAssert(int id, _In_z_ const char* cond, _In_z_ const char* file, int line, _In_z_ const char* format, hkVarArgs::VaTypes argTypes, ...)
{
    hkVarArgs::FixedArray<16> args;
    HK_VARARGS_UNPACK(args, argTypes);

    hkStringBuf str;
    str.setJoin(cond, ": ");
    str.appendFormatV(format, args);
    return ::hkErrorFwd::messageAssert(id, str.cString(), file, line);
}

_Analysis_noreturn_
void HK_CALL hkErrorFwd::messageFatalError(int id, _In_z_ const char* description, _In_z_ const char* file, int line)
{
    hkErrorRouter::getInstance().message(hkError::MESSAGE_FATAL_ERROR, id, description, file, line);
    hkError::getInstance().message(hkError::MESSAGE_FATAL_ERROR, id, description, file, line);
#if defined(HK_COMPILER_MSVC_VERSION) && (HK_COMPILER_MSVC_VERSION >= 1610) // as per __fastfail() declaration in winnt.h
    #ifndef FAST_FAIL_FATAL_APP_EXIT
    #define FAST_FAIL_FATAL_APP_EXIT 7
    #endif
    __fastfail(FAST_FAIL_FATAL_APP_EXIT);
#elif defined(HK_PLATFORM_ANDROID)
    abort();
#else
    std::abort();
#endif
    // unreachable
}

_Analysis_noreturn_
void HK_CALL hkErrorFwd::messageFatalError(int id, _In_z_ const char* file, int line, _In_z_ const char* format, hkVarArgs::VaTypes argTypes, ...)
{
    hkVarArgs::FixedArray<16> args;
    HK_VARARGS_UNPACK(args, argTypes);
    // Try not to allocate
    char errBuf[4096];
    errBuf[0] = '\0';
    hkStringBuf str; str.getArray().setDataUserFree(errBuf, 1, sizeof(errBuf));
    str.formatV(format, args);
    ::hkErrorFwd::messageFatalError( id, str.cString(), file, line );
    // unreachable
}

void HK_CALL hkErrorFwd::setEnabled(int id, bool enabled)
{
    hkErrorRouter::getInstance().setEnabled(id, enabled);
    return hkError::getInstance().setEnabled(id, enabled);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
