// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/System/Io/Writer/Buffered/hkBufferedStreamWriter.h>
#include <Common/Base/Object/hkSingleton.h>
#include <Common/Base/System/Error/hkDefaultError.h>

HK_SINGLETON_SUBCLASS_IMPLEMENTATION(hkError, hkDefaultError);

hkErrStream::hkErrStream(_Inout_updates_bytes_(bufSize) void* buf, int bufSize)
    : hkOstream((hkStreamWriter*)HK_NULL)
{
    int sizeOfWriter = HK_NEXT_MULTIPLE_OF(16, sizeof(hkBufferedStreamWriter));
    void* p = ((char*)buf) + bufSize - sizeOfWriter;
    hkStreamWriter* writer = new (p) hkBufferedStreamWriter(buf, bufSize - sizeOfWriter, true);
    m_writer.setAndDontIncrementRefCount(writer);
}

hkErrStream::~hkErrStream()
{
    m_writer.unsetAndDontDecrementRefCount(); // We know this is safe, as the writer is created with an in-place new
}

extern "C" HK_EXPORT_COMMON void HK_CALL hkErrorMessage(_In_z_ const char* c);

void HK_CALL hkErrorMessage(_In_z_ const char* c)
{
    HK_ERROR(0x2636fe25, c);
}

/* Asserts Id's for use with HK_ASSERT
 * Pick an ID, use it and delete it from the list below

0x6569eafd
0x7e9ce7c5
0x21be44cd
0x2f718942
0x63482c0a
0x1b87e64c
0x7f47a720
0x58f928ef
0x4fda0b4a
0x5b6c0e14
*/

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
