// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

/// This is the default implementation of our error handling interface.
/// It supports error and assert enabling and disabling and where possible
/// it walks and reports the full stack trace leading up to the error.
/// Usually you will derive from this class and override showMessage when
/// integrating this class in you game.
class HK_EXPORT_COMMON hkDefaultError : public hkError
{
public:

    HK_DECLARE_CLASS(hkDefaultError, New);
    hkDefaultError(_In_opt_ hkErrorReportFunction errorReportFunction = HK_NULL, _Inout_opt_ void* errorReportObject = HK_NULL);

    virtual void setEnabled(int id, hkBool enabled) HK_OVERRIDE;

    virtual hkBool isEnabled(int id) HK_OVERRIDE;

    virtual void enableAll() HK_OVERRIDE;

    virtual void setMinimumMessageLevel(Message msg) HK_OVERRIDE;

    virtual Message getMinimumMessageLevel() HK_OVERRIDE;

    virtual int message(hkError::Message msg, int id, _In_z_ const char* description, _In_opt_z_ const char* file, int line) HK_OVERRIDE;

    virtual void sectionBegin(int id, _In_z_ const char* sectionName) HK_OVERRIDE;

    virtual void sectionEnd() HK_OVERRIDE;

protected:

        virtual void showMessage( hkError::Message msg, int id, _In_z_ const char* desc, _In_z_ const char* file, int line ) const;

        virtual void formMessage( hkError::Message msg, int id, _In_z_ const char* desc, _In_z_ const char* file, int line, hkStringBuf& messageOut ) const;

        virtual void getMessageTypeString( hkError::Message msg, _Outptr_result_z_ const char** msgType ) const;

        virtual bool shouldReportStackTrace( hkError::Message msg ) const;

public:

    /// A map of the disabled assert IDs.
    hkPointerMap<int, int> m_disabledAssertIds;

    hkArray<int> m_sectionIds;

    /// This function will be used to report errors.
    hkErrorReportFunction m_errorFunction;

    void* m_errorObject;

    hkError::Message m_minimumMessageLevel;
    mutable hkCriticalSection m_lock;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
