// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Error/hkAssert.h>
#include <Common/Base/Container/String/hkUtf8.h>
#include <Common/Base/Fwd/hkcstdarg.h>
#include <stdio.h>

#ifdef HK_PLATFORM_WIN32
    #include <crtdbg.h>
    #include <windows.h>
#endif

namespace hkAssert
{
    namespace Detail
    {
        static assertHandlers g_AssertHandler = { defaultAssertHandler, defaultDisableAssert };

        bool assertFailedNoVarArgs(int id, _In_z_ const char* file, unsigned int line, _In_z_ const char* function, _In_z_ const char* expression, _In_z_ const char* userErrorMsg)
        {
            // always do a debug-break if no assert handler is installed
            if ( g_AssertHandler.m_assertHandler == nullptr )
                return true;

            return (*g_AssertHandler.m_assertHandler)(id, file, line, function, expression, userErrorMsg );
        }

        bool assertFailed( int id, _In_z_ const char* file, unsigned int line, _In_z_ const char* function, _In_z_ const char* expression, _In_z_ const char* userErrorMsg, hkVarArgs::VaTypes argTypes, ... )
        {
            // always do a debug-break if no assert handler is installed
            if ( g_AssertHandler.m_assertHandler == nullptr )
                return true;

            hkVarArgs::FixedArray<16> args;
            HK_VARARGS_UNPACK( args, argTypes );

            hkStringBuf str;
            if (userErrorMsg)
            {
                str.formatV(userErrorMsg, args);
            }

            return (*g_AssertHandler.m_assertHandler)(id, file, line, function, expression, str);
        }

        void disableAssert( int id )
        {
            if ( g_AssertHandler.m_disableAssert == nullptr )
                return;

            (*g_AssertHandler.m_disableAssert)(id);
        }
    }

    assertHandlers setAssertHandlers( assertHandlers newHandlers )
    {
        const assertHandlers oldHandler = Detail::g_AssertHandler;
        Detail::g_AssertHandler = newHandlers;

        return oldHandler;
    }

    bool defaultAssertHandler( int id, _In_z_ const char* file, unsigned int line, _In_z_ const char* function, _In_z_ const char* expression, _In_z_ const char* userErrorMsg )
    {
        char formattedText[1024 * 4];
        hkString::snPrintf(formattedText, HK_COUNT_OF(formattedText), HK_COUNT_OF(formattedText), "in '%s', condition: '%s'. %s", function, expression, userErrorMsg);
        formattedText[1024 * 4 - 1] = '\0';

        // This creates memory leaks due to setjmp / longjmp in test macros!
        //hkStringBuf assertText;
        //assertText.format( "{}({}): in {}\n:Condition: '{}'\n{}", file, line, function, expression, userErrorMsg );

        bool enableBreakpoint = true;

        if ( !::hkErrorFwd::messageAssert( id, formattedText, file, line ) )
        {
            enableBreakpoint = false;
        }

        
        {

        }

#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_DURANGO)

#   if defined(HK_DEBUG_SLOW)
        {
            

            

            //const int result = _CrtDbgReportW( _CRT_ASSERT, hkUtf8::WideFromUtf8( file ), line, nullptr,
            //  L"\n'%S'\n%S", hkUtf8::WideFromUtf8( expression ).cString(), hkUtf8::WideFromUtf8( userErrorMsg ).cString() );

            //if ( result == 0 ) // user clicked 'ignore'
            //{
            //  ::hkErrorFwd::setEnabled( id, false );
            //  enableBreakpoint = false;
            //}
        }
#   else
        {
            //// release version of the ASSERT dialog (small faked one)
            //::MessageBoxW( NULL, hkUtf8::WideFromUtf8( assertText ).cString(), L"Assertion violated!", MB_ICONSTOP | MB_OK );
        }
#   endif

#endif

        return enableBreakpoint;
    }

    void defaultDisableAssert( int id )
    {
        ::hkErrorFwd::setEnabled( id, false );
    }
}




// Large code modifications (replace all)
//      replace HK_ASSERTV by HK_ASSERT


// Long Term:
//      Look into HK_WARN, HK_ERROR etc.

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
