// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Implements a module
#ifdef HK_DYNAMIC_DLL
#   define HK_IMPLEMENT_DLL_MODULE(DllModuleClass)              \
    extern "C"                                                  \
    {                                                           \
        __declspec(dllexport) hkDllModule* CreateDllInterface() \
        {                                                       \
            return new DllModuleClass();                        \
        }                                                       \
    }
#else
#   define HK_IMPLEMENT_DLL_MODULE(DllModuleClass)
#endif

/// Abstract interface for a Dll module. The module will be created when the Dll is loaded and kept alive for as long
/// as the Dll is loaded. It acts as a Dll-specific singleton.
class HK_EXPORT_COMMON hkDllModule : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS(hkDllModule, New, ReflectIdentity);

        /// Called when the Dll is loaded
        virtual void init() = 0;

        /// Returns true if the Dll can be unloaded
        virtual bool canQuit() = 0;

        /// Called when the Dll is unloaded
        virtual void quit() = 0;

    protected:

        hkDllModule(){};
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
