// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkDynamicLibrary;
class hkDllModule;

/// A Dll manager
class HK_EXPORT_COMMON hkDllManager : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS(hkDllManager, New);

    public:

        /// Constructor
        hkDllManager();

        /// Destructor
        virtual ~hkDllManager();

    public:

        /// Adds a search path to the list of paths seen by this manager
        virtual void addSearchPath(_In_z_ const char* dir, _In_z_ const char* ext);

        /// Loads all Dlls found in the search paths
        void loadAll();

        /// Unloads all Dlls
        void unloadAll();

        /// Loads a single Dll
        _Ret_maybenull_ hkDynamicLibrary* loadDll(_In_z_ const char* dllName);

        /// Unloads a single Dll
        hkResult unload(_In_z_ const char* dllName);

    public:

        /// Debug. Prevents the unloading of Dlls.
        void preventUnload();

        // Plugin names are just the type names
        // If the type is not found, will try to load the dllname (if null provided then will use start of name up to second caps, eg hkeFxComponent type will look for hkeFx.hkeplugin)
        _Ret_maybenull_ const hkReflect::Type* load(_In_z_ const char* name, _In_opt_z_ const char* dllname = HK_NULL);

        // this would normally be on demand from scene data about to be loaded
        // same as calling load(name)->newInstance();
        virtual _Ret_maybenull_ hkReferencedObject* createInstance(_In_z_ const char* name, _In_opt_z_ const char* dllname = HK_NULL);

        hkResult unload(_Inout_ hkDynamicLibrary* dll);

    protected:

        /// Loads a Dll (native)
        _Ret_maybenull_ hkDynamicLibrary* loadDllNative(_In_z_ const char* nativePath);

        struct DllSearchPath
        {
            hkStringPtr m_dir;
            hkStringPtr m_ext;
        };

        /// A Dll entry
        struct Dll
        {
            /// Constructor
            Dll();

            hkStringPtr m_dllname;              ///< The name of the Dll
            hkStringPtr m_nativePath;           ///< The native path to the Dll
            hkRefPtr<hkDynamicLibrary> m_dll;   ///< An OS-agnostic interface to the Dll
            hkRefPtr<hkDllModule> m_module;     ///< The module hosted by the Dll
        };

    protected:

        /// The search paths
        hkArray< DllSearchPath > m_searchPaths;

        /// The loaded Dlls
        hkArray<Dll> m_dlls;

        // Debug. Prevents the unloading of Dlls
        bool m_preventUnload;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
