// TKBMS v1.0 ----------------------------------------------------
//
// PLATFORM   : WIN32 X64 METRO_X86 METRO_X64 METRO_ARM APOLLO_X86 APOLLO_ARM UWP_X86 UWP_X64 UWP_ARM
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


// This provides a default implementation of dllMain that declares initialization code to be executed only
// after or if hkBaseSystem is initialized.
#ifndef HK_DYNAMIC_DLL
#error "Should not be included in a non-HK_DYNAMIC_DLL build"
#endif

#include <Common/Base/Config/hkConfigVersion.h>
#include <Common/Base/Fwd/hkwindows.h>
#include <Common/CommonAll/hkCommonAll.h> 
#include <Common/Base/System/hkBaseSystem.h>
#include <Common/Base/System/hkBaseSystem.hxx>

#if !defined(HK_DLL_BUILD) || (HK_DLL_BUILD!=HK_COMMON_BUILD)
#   ifdef HK_BUILDING_WITH_ENGINE
#       define MAY_HAVE_LOCAL_SERVICES
#       include <Common/NewBase/Services/hkServices2.h> 
#       include <Common/NewBase/Services/hkServices2.hxx> 
#       include <Common/NewBase/Reflection/Util/hkDynamicTypeManager.h> 
#   endif
#   define MAY_HAVE_LOCAL_INIT_NODES
#   include <Common/Base/System/Log/hkLogModule.cxx>
#endif

#include <Common/Base/Reflect/TypeReg/Detail/hkTypeRegNode.hxx>
#include <Common/Base/Types/Properties/hkPropertyRegistry.hxx>








#ifdef MAY_HAVE_LOCAL_INIT_NODES
namespace{
namespace PRIVATE
{
    hkBaseSystem::InitList s_dllInitList("DLL");
}
}
#endif


namespace
{
    // Compares the SDK this DLL was built with with the SDK the hkCommonAll.dll was built with.
    void checkSdkVersion()
    {
        if (hkString::strCmp( HAVOK_SDK_VERSION_STRING, hkCommonDll::VersionString ) != 0)
        {
            hkStringBuf sErr;
            sErr.printf( "** Dll Version mismatch: This Dll is [%s], but Common is [%s]. ** ", HAVOK_SDK_VERSION_STRING, hkCommonDll::VersionString );

            HK_WARN_ALWAYS(0xabba7aa5, sErr.cString() );
        }
    }
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, ULONG fdwReason, LPVOID lpvReserved)
{
    switch ( fdwReason )
    {
        case DLL_PROCESS_ATTACH:
        {
            checkSdkVersion();

            #ifdef MAY_HAVE_LOCAL_INIT_NODES
            if(hkBaseSystem::isInitialized())
            {
                PRIVATE::s_dllInitList.init();
            }
            else
            {
                hkBaseSystem::registerInitList(&PRIVATE::s_dllInitList);
            }
            #endif

            break;
        }

        case DLL_PROCESS_DETACH:
        {
            #ifdef MAY_HAVE_LOCAL_INIT_NODES
            if(hkBaseSystem::isInitialized() && (lpvReserved == HK_NULL)) // lpvReserved != NULL on process terminate, which has base sys etc in ill defined state
            {
                PRIVATE::s_dllInitList.quit();
            }
            #endif
            break;
        }

        case DLL_THREAD_ATTACH:
        case DLL_THREAD_DETACH:
            break;
    }
    return TRUE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
