// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : WIN32 X64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#include <windows.h>

#include <Common/Base/Container/String/hkUtf8.h>


namespace
{
    class WindowsDynamicLibrary : public hkDynamicLibrary
    {
        public:

            HK_DECLARE_CLASS(WindowsDynamicLibrary, New);

            WindowsDynamicLibrary( HMODULE handle );
            ~WindowsDynamicLibrary();

            //
            // hkDynamicLibrary implementation
            //

            virtual _Ret_maybenull_ void* findSymbol(_In_z_ const char* symbolName) const HK_OVERRIDE;

        protected:

            /// Not implemented.
            WindowsDynamicLibrary( const WindowsDynamicLibrary& );

        protected:

            /// Handle to the loaded windows process/
            HMODULE m_handle;
    };

    WindowsDynamicLibrary::WindowsDynamicLibrary( HMODULE handle )
    : hkDynamicLibrary(), m_handle( handle )
    {
        HK_ASSERT_NO_MSG(0x6f9fd8b9, m_handle );
    }

    WindowsDynamicLibrary::~WindowsDynamicLibrary()
    {
        HK_ASSERT_NO_MSG(0x81fb857, m_handle );
        if (m_allowUnload)
        {
            HK_ON_DEBUG( BOOL res = ) FreeLibrary( m_handle );
            HK_ASSERT_NO_MSG( 0x122b0b9a, res );
        }
    }

    _Ret_maybenull_ void* WindowsDynamicLibrary::findSymbol(_In_z_ const char* symbolName) const
    {
        HK_ASSERT_NO_MSG(0x213ec044, m_handle );
        return GetProcAddress( m_handle, symbolName );
    }
}

hkRefNew<hkDynamicLibrary> hkDynamicLibrary::load(_In_z_ const char* path)
{
#if !defined(HK_PLATFORM_METRO)
    HMODULE handle = LoadLibraryW( hkUtf8::WideFromUtf8( path ).cString() );

    if( handle )
    {
        return new WindowsDynamicLibrary( handle );
    }
    else
    {
        return HK_NULL;
    }
#else
    return HK_NULL;
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
