// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// A platform-agnostic dynamic library
class HK_EXPORT_COMMON hkDynamicLibrary : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS(hkDynamicLibrary, New);

        /// Find symbol exported symbol table in the loaded dynamic library.
        virtual _Ret_maybenull_ void* findSymbol( _In_z_ const char* symbolName ) const = 0;

        /// Static init ctor. We rely on OS to do reference counting for us.
        static hkRefNew<hkDynamicLibrary> load(_In_z_ const char* path);

        /// When debugging leaks etc, it can be helpful to keep Dlls in memory longer than normal
        void preventUnload(bool prevent);

    protected:

        /// Do not call default ctors directly. See load().
        hkDynamicLibrary();

        /// Not implemented.
        hkDynamicLibrary(const hkDynamicLibrary&);

    protected:

        bool m_allowUnload;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
