// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/System/Dll/DynamicLibrary/hkDynamicLibrary.h>

//
//  Constructor

hkDynamicLibrary::hkDynamicLibrary()
:   m_allowUnload(true)
{}

void hkDynamicLibrary::preventUnload(bool prevent)
{
    m_allowUnload = !prevent;
}

// Platform dependent implementations
#if defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_WINRT)
#   include <Common/Base/System/Dll/DynamicLibrary/hkWindowsDynamicLibrary.cxx>
#elif defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_TIZEN)
#   include <Common/Base/System/Dll/DynamicLibrary/hkLinuxDynamicLibrary.cxx>
#elif defined(HK_PLATFORM_WIIU)
#   include <Common/Base/System/Dll/DynamicLibrary/hkWiiUDynamicLibrary.cxx>
#elif defined(HK_PLATFORM_PS4)
#   include <Common/Base/System/Dll/DynamicLibrary/hkPs4DynamicLibrary.cxx>
#elif defined(HK_PLATFORM_PSVITA)
#   include <Common/Base/System/Dll/DynamicLibrary/hkPsVitaDynamicLibrary.cxx>
#else
#   include <Common/Base/System/Dll/DynamicLibrary/hkDynamicLibrary.hxx>
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
