// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
template<typename T>
_Ret_maybenull_ T* hkSerialize::Load::toObject(const hkIo::Detail::ReadBufferAdapter& rba)
{
    if( hkReflect::Var v = toVar(rba, hkReflect::getType<T>()) )
    {
        if ( T* object = v.dynCast<T>() )
        {
            return object;
        }
        v.destroy();
    }
    return HK_NULL;
}

template<typename T>
_Ret_maybenull_ T* hkSerialize::Load::toObject(hkIo::ReadBuffer& readBuffer)
{
    if( hkReflect::Var v = toVar(readBuffer, hkReflect::getType<T>()) )
    {
        if ( T* object = v.dynCast<T>() )
        {
            return object;
        }
        v.destroy();
    }
    return HK_NULL;
}

template<typename T>
_Ret_maybenull_ T* hkSerialize::Load::toObject(_In_reads_bytes_(bufSize) const void* buf, hkUlong bufSize, _Out_opt_ hkUlong* used)
{
    if( hkReflect::Var v = toVar(buf, bufSize, hkReflect::getType<T>(), used) )
    {
        if ( T* object = v.dynCast<T>() )
        {
            return object;
        }
        v.destroy();
    }
    return HK_NULL;
}

template<typename T>
_Ret_maybenull_ T* hkSerialize::InplaceLoad::toObject(_Out_writes_bytes_(bufLen) void* buf, hkUlong bufLen)
{
    if( hkReflect::Var v = toVar(buf, bufLen, hkReflect::getType<T>()) )
    {
        return v.dynCast<T>();
    }
    return HK_NULL;
}

template<typename READ_FORMAT>
hkSerialize::Load& hkSerialize::Load::withFormat()
{
    HK_ASSERT(0x2322A14D, m_format == nullptr, "Format has already been set");
    m_format.setAndDontIncrementRefCount(new READ_FORMAT());
    return *this;
}

template<typename WRITE_FORMAT>
hkSerialize::Save& hkSerialize::Save::withFormat()
{
    HK_ASSERT(0x1322A14E, m_formatPtr == nullptr, "Format has already been set");
    m_formatPtr.setAndDontIncrementRefCount(new WRITE_FORMAT());
    return *this;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
