// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HK_VERSION_BUNDLE_UTIL_H
#define HK_VERSION_BUNDLE_UTIL_H

struct hkPatchDependencies;
class hkMemoryAllocator;

namespace hkVersionBundleUtil
{
    class TypeFromNameCb
    {
    public:
        virtual _Ret_maybenull_ void* getTypeFromName(_In_z_ const char* name) = 0;
        virtual _Ret_maybenull_ const hkReflect::Type* checkForBasicType(_In_z_ const char* name) = 0;
    };

    class TypeFromTypeCb
    {
    public:
        virtual _Ret_maybenull_ void* getTypeFromType(_In_ const hkReflect::Type* type) = 0;
    };

    struct HK_EXPORT_COMMON Field
    {
        HK_DECLARE_CLASS(Field, New);

        ~Field();

        enum TypeKind
        {
            TYPE_INVALID = -1,
            TYPE_BASIC = 0,
            TYPE_POINTER,
            TYPE_TYPE_POINTER, // Pointer to a field or a type
            TYPE_STRUCT,
            TYPE_HKARRAY,
            TYPE_CARRAY,
            TYPE_SPECIAL, // Special fields such as foreignUtil, contains a stashed type pointer
        };

        hkStringPtr m_name;
        hkStringPtr m_typeName;
    private:
        void* m_type;
    public:
        int m_tuples; // m_type = TYPE_CARRAY
        TypeKind m_typeKind;
        bool m_isSerializable;

        template<TypeKind KIND>
        void setType(_In_ const void* t) { m_typeKind = KIND; m_type = const_cast<void*>(t); }

        _Ret_maybenull_ const hkReflect::Type* getTypeAsBasic() const { return m_typeKind == TYPE_BASIC ? reinterpret_cast<const hkReflect::Type*>(m_type) : HK_NULL; }
        _Ret_maybenull_ const hkReflect::Type* getTypeAsSpecial() const { return m_typeKind == TYPE_SPECIAL ? reinterpret_cast<const hkReflect::Type*>(m_type) : HK_NULL; }
        template<typename T> T getTypeAsStruct() const { return m_typeKind == TYPE_STRUCT ? reinterpret_cast<T>(m_type) : 0; }
        _Ret_maybenull_ Field* getTypeAsField() const { return (m_typeKind == TYPE_POINTER || m_typeKind == TYPE_HKARRAY || m_typeKind == TYPE_CARRAY) ? reinterpret_cast<Field*>(m_type) : HK_NULL; }

        bool isSerializable() const { return m_isSerializable; }
        static _Ret_maybenull_ Field* createFromTypeDescription(TypeFromNameCb& cb, _In_z_ const char* name, _In_z_ const char* typeNameStr);
        static _Ret_notnull_ Field* createFromStaticType(TypeFromTypeCb& cb, _In_z_ const char* name, _In_ const hkReflect::Type* staticType, bool isSerializable = true);

        bool nameEquals(const char* otherName) { return hkString::strCmp(m_name, otherName) == 0; }
    };

    // Some fixed arrays of floats are treated specially
    bool isSpecialFloatArray(_In_ const hkReflect::Type* staticTypeIn);
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
