// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HK_VERSION_BUNDLE_H
#define HK_VERSION_BUNDLE_H

#include <Common/Base/Serialize/Core/hkSerializeCore.h>
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>

namespace hkSerialize
{
    /// This is used to pass information from the Compat patcher when required
    struct HK_EXPORT_COMMON CompatTypeParentInfo
    {
        HK_DECLARE_CLASS(CompatTypeParentInfo, Reflect, New, RuntimeAttribute);
        HK_RECORD_ATTR(hk::Serialize(false));

        struct Parent
        {
            HK_DECLARE_CLASS(Parent, Reflect, New);
            HK_RECORD_ATTR(hk::Serialize(false));

            Parent(const char* n = nullptr, int v = -1) : m_name(n), m_version(v), m_next(nullptr) {}
            const char* m_name;
            int m_version;
            struct Parent* m_next;
        };

        Parent* m_firstParent;
    };

    class HK_EXPORT_COMMON VersionBundle : public hkReferencedObject
    {
    public:
        VersionBundle(hkReflect::Version::PatchRegistry& patchReg, hkReflect::MutableTypeReg& typeReg);
        ~VersionBundle();

        // Loader will cache data from multiple bundles, however it does expect them to be consistent
        // TODO: Exactly what do we guarantee here?
        hkViewPtr<hkSerialize::Bundle> applyPatchesTo(hkViewPtr<hkSerialize::Bundle> bundleIn/*, hkReflect::TypeReg* typeReg, hkReflect::Version::PatchRegistry* patchReg*/, bool failIfVersioningRequired);
        //const hkReflect::Type* finalTypeAccordingToPatches(const char* name, int version);

        /// Return the number of types appended
        int appendAllTypes(hkArray<const hkReflect::Type*>& typesOut);

        _Ret_notnull_ hkReflect::MutableTypeReg* createBackwardCompatibleTypeReg();
        struct Impl;

    private:
        Impl* m_impl;
    };

    // Helper interface for patch functions
    struct PatchFunctionHelper
    {
        hkReflect::Var newObject(_In_ const hkReflect::Type* t) { return newArray(t, -1)[0]; };
        hkReflect::Var newObject(_In_z_ const char* typeName) { return newArray(typeName, -1)[0]; };

        // cardinality = -1 means single var.
        virtual hkReflect::ArrayValue newArray(_In_ const hkReflect::Type* t, int cardinality) = 0;
        virtual hkReflect::ArrayValue newArray(_In_z_ const char* typeName, int cardinality) = 0;

        struct PointerValue
        {
            int m_id;
        };

        virtual PointerValue getPointerValue(hkReflect::Var v) = 0;
        virtual hkResult setPointerValue(hkReflect::Var v, PointerValue pv) = 0;
        virtual hkResult copyPointerValue(hkReflect::Var dstVar, hkReflect::Var srcVar) { return setPointerValue(dstVar, getPointerValue(srcVar)); }

        virtual _Ret_notnull_ const hkReflect::PointerType* getPointerTypeTo(_In_z_ const char* pointerName, _In_ const hkReflect::Type* pointedType) = 0;
        virtual _Ret_notnull_ const hkReflect::ArrayType* getArrayTypeTo(_In_z_ const char* arrayName, _In_ const hkReflect::Type* subType, int fixedCount) = 0;
    };
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
