// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkRootLevelContainer::hkRootLevelContainer()
{
}

HK_INLINE hkRootLevelContainer::hkRootLevelContainer(const hkRootLevelContainer& other)
{
    *this = other;
}

HK_INLINE hkRootLevelContainer::~hkRootLevelContainer()
{
}

template<typename T>
inline _Ret_maybenull_ T* hkRootLevelContainer::findObject( _In_opt_ const void* prevObject ) const
{
    if( void* p = findObjectByTypeName( hkReflect::getName<T>(), prevObject) )
    {
        return static_cast<T*>(p);
    }
    return HK_NULL;
}

HK_INLINE hkRootLevelContainer::NamedVariant::NamedVariant()
{
}


HK_INLINE void hkRootLevelContainer::NamedVariant::set(_In_z_ const char* name, _In_ void* object, _In_ const hkReflect::Type* klass)
{
    m_name = name;
    m_variant.set(object, klass);
    m_className = klass->getName();
}

HK_INLINE void hkRootLevelContainer::NamedVariant::set(_In_z_ const char* name, const hkReflect::Var& v)
{
    m_name = name;
    m_variant = v;
    m_className = HK_NULL;
    if( const hkReflect::Type* t = m_variant.getType() )
    {
        m_className = t->getName();
    }
}

HK_INLINE _Ret_z_ const char* hkRootLevelContainer::NamedVariant::getTypeName() const
{
    
    if( const hkReflect::Type* t = m_variant.getType() )
    {
        return t->getName();
    }
    return static_cast<const char*>(m_className); 
}

HK_INLINE _Ret_z_ const char* hkRootLevelContainer::NamedVariant::getName() const
{
    return m_name;
}

HK_INLINE _Ret_notnull_ void* hkRootLevelContainer::NamedVariant::getObject() const
{
    return m_variant.val();
}

HK_INLINE _Ret_notnull_ const hkReflect::Type* hkRootLevelContainer::NamedVariant::getType() const
{
    return m_variant.getType();
}

HK_INLINE const hkRefVariant& hkRootLevelContainer::NamedVariant::getRefVariant() const
{
    return m_variant;
}

template<typename T>
HK_INLINE _Ret_maybenull_ T* hkRootLevelContainer::NamedVariant::get() const
{
    return hkReflect::exactMatchDynCast<T>(m_variant);
}

template<typename T>
HK_INLINE _Ret_maybenull_ T* hkRootLevelContainer::NamedVariant::getByTypeName() const
{
    return m_className == hkReflect::getName<T>() ? static_cast<T*>(m_variant.val()) : HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
