// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// This is the root level class exported by our tools.
/// It contains an array of Variants and associated names.
class HK_EXPORT_COMMON hkRootLevelContainer
{
    public:
        HK_DECLARE_CLASS(hkRootLevelContainer, Reflect, New);

            /// hkRootLevelContainer constructor.
        HK_INLINE hkRootLevelContainer();
            /// hkRootLevelContainer copy constructor.
        HK_INLINE hkRootLevelContainer(const hkRootLevelContainer& other);

            /// hkRootLevelContainer destructor.
        HK_INLINE ~hkRootLevelContainer();

            /// A variant with a name string.
            /// This class also redundantly stores the class name so that you can identify
            /// the type even if this object comes from a packfile without metadata (i.e., with
            /// null m_variant.m_class)
        class HK_EXPORT_COMMON NamedVariant
        {
            //+version(1)
            public:

                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SERIALIZE, hkRootLevelContainer::NamedVariant );
                HK_DECLARE_REFLECTION();

                    /// hkRootLevelContainer::NamedVariant constructor.
                HK_INLINE NamedVariant();

                NamedVariant(const _In_z_ char* name, _In_ void* object, _In_ const hkReflect::Type* klass);
                NamedVariant(_In_z_ const char* name, const hkReflect::Var& v);

                    /// Set named variant name, object and type.
                template<typename T>
                HK_INLINE void set(_In_opt_z_ const char* name, _In_ T* object) { set(name ? name : hkReflect::getType<T>()->getName(), object, hkReflect::getType<T>()); }

                    /// Set named variant name, object and class.
                HK_INLINE void set(_In_z_ const char* name, _In_ void* object, _In_ const hkReflect::Type* klass);

                    /// Set named variant name, object and class using variant v.
                HK_INLINE void set(_In_z_ const char* name, const hkReflect::Var& v);

                    /// Get named variant type name.
                HK_INLINE _Ret_z_ const char* getTypeName() const;

                    /// Get named variant name.
                HK_INLINE _Ret_z_ const char* getName() const;

                    /// Get named variant object pointer.
                HK_INLINE _Ret_notnull_ void* getObject() const;

                    /// Get named variant class.
                HK_INLINE _Ret_notnull_ const hkReflect::Type* getType() const;

                    /// Get named variant.
                HK_INLINE const hkRefVariant& getRefVariant() const;

                template<typename T> inline _Ret_maybenull_ const T* isA() const { return hkDynCast<T>(m_variant); }
                template<typename T> inline _Ret_maybenull_ T* isA() { return hkDynCast<T>(m_variant); }

                    /// If the variant is exactly type T, return it. If not, return HK_NULL
                template<typename T>
                HK_INLINE _Ret_maybenull_ T* get() const;

                    /// This method does not check the exact type of the variant. Use this instead of get() when the
                    /// exact type cannot be retrieved (e.g. the type might not have been registered).
                template<typename T>
                inline _Ret_maybenull_ T* getByTypeName() const;
            private:
                hkStringPtr m_name;
                hkStringPtr m_className;
                hkRefVariant m_variant;
        };

            /// Iterates over the objects held in the container returning a pointer
            /// to the first object after prevObject, with a type corresponding to 'typeName'.
            /// If prevObject is null then the search begins from the start of the container.
        template<typename T>
        inline _Ret_maybenull_ T* findObject(_In_opt_ const void* prevObject = HK_NULL ) const;

            /// Iterates over the objects held in the container returning a pointer
            /// to the first object after prevObject, with a type corresponding to 'typeName'.
            /// If prevObject is null then the search begins from the start of the container.
        _Ret_maybenull_ void* findObjectByTypeName(_In_z_ const char* typeName, _In_opt_ const void* prevObject = HK_NULL ) const;

            /// Iterates over the objects held in the container returning a pointer
            /// to the first object after prevObject, with a name corresponding to 'objectName'.
            /// If prevObject is null then the search begins from the start of the container.
        _Ret_maybenull_ void* findObjectByName(_In_z_ const char* objectName, _In_opt_ const void* prevObject = HK_NULL) const;

        _Ret_maybenull_ const hkRefVariant* findVariantByName(_In_z_ const char* objectName, _In_opt_ const void* prevObject = HK_NULL) const;

    public:

            /// An array of NamedVariants.
        hkArray<class NamedVariant> m_namedVariants;
};

#include <Common/Base/Serialize/Util/hkRootLevelContainer.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
