// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Container/String/hkStringBuf.h>

hkRootLevelContainer::NamedVariant::NamedVariant(_In_z_ const char* name, _In_ void* object, _In_ const hkReflect::Type* klass)
{
    set(name, object, klass);
}

hkRootLevelContainer::NamedVariant::NamedVariant(_In_z_ const char* name, const hkReflect::Var& v)
{
    set(name, v);
}

_Ret_maybenull_ void* hkRootLevelContainer::findObjectByTypeName(_In_z_ const char* typeName, _In_opt_ const void* prevObject) const
{
    HK_ASSERT_NO_MSG(0x07649ef4, typeName);
    int index = 0;
    while((prevObject) && (index < m_namedVariants.getSize()) && (m_namedVariants[index++].getObject() != prevObject) )  { }

    for( int i = index; i < m_namedVariants.getSize(); ++i )
    {
        const char* variantTypeName = m_namedVariants[i].getTypeName();
        if(variantTypeName && hkString::strCmp(typeName, variantTypeName) == 0)
        {
            return m_namedVariants[i].getObject();
        }
    }
    return HK_NULL;
}

_Ret_maybenull_ void* hkRootLevelContainer::findObjectByName(_In_z_ const char* objectName, _In_opt_ const void* prevObject) const
{
    HK_ASSERT_NO_MSG(0x07649ef5, objectName);
    int index = 0;

    while( (prevObject) && (index < m_namedVariants.getSize()) && (m_namedVariants[index++].getObject() != prevObject) )  { }

    for( int i = index; i < m_namedVariants.getSize(); ++i )
    {
        if( m_namedVariants[i].getName() && hkString::strCmp( objectName, m_namedVariants[i].getName() ) == 0 )
        {
            return m_namedVariants[i].getObject();
        }
    }
    return HK_NULL;
}

_Ret_maybenull_ const hkRefVariant* hkRootLevelContainer::findVariantByName(_In_z_ const char* objectName, _In_opt_ const void* prevObject) const
{
    HK_ASSERT_NO_MSG(0x07649ef5, objectName);
    int index = 0;

    while( (prevObject) && (index < m_namedVariants.getSize()) && (m_namedVariants[index++].getObject() != prevObject) )  { }

    for( int i = index; i < m_namedVariants.getSize(); ++i )
    {
        if( m_namedVariants[i].getName() && hkString::strCmp( objectName, m_namedVariants[i].getName() ) == 0 )
        {
            return &m_namedVariants[i].getRefVariant();
        }
    }
    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
