// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkStreamReader;
class hkRootLevelContainer;
class hkVersionRegistry;
class hkResource;

/// Utility class to simplify loading packfiles and tagfiles.
/// This class is mainly useful for demo code where it keeps a reference
/// to all the resources it loads and cleans them up on destruction.
/// If you need more control, use hkSerializeUtil instead.
class HK_EXPORT_COMMON hkLoader : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SERIALIZE);

            /// Releases the references to all loaded memory
        ~hkLoader();

            /// Loads from a packfile or tagfile, applies versioning steps if needed,
            /// explicitly allocates and keeps a handle to the memory allocated.
            /// This method is usually called multiple times to load several different assets.
            /// Implicitly uses the built-in registry
        virtual _Ret_maybenull_ hkRootLevelContainer* load(_In_z_ const char* filename);

            /// Loads from a packfile or tagfile, applies versioning steps if needed,
            /// explicitly allocates and keeps a handle to the memory allocated.
            /// This method is usually called multiple times to load several different assets.
            /// Implicitly uses the built-in registry.
        virtual _Ret_maybenull_ hkRootLevelContainer* load(_Inout_ hkStreamReader* reader);

            /// Loads from a packfile or tagfile, applies versioning steps if needed,
            /// explicitly allocates and keeps a handle to the memory allocated.
            /// This method is usually called multiple times to load several different assets.
            /// Does not assume that the hkRoootLevelContainer is the top level type.
            /// Implicitly uses the built-in registry.
        virtual _Ret_maybenull_ void* load(_Inout_ hkStreamReader* reader, _In_ const hkReflect::Type* expectedTopLevelType);

            /// Loads from a packfile or tagfile, applies versioning steps if needed,
            /// explicitly allocates and keeps a handle to the memory allocated.
            /// This method is usually called multiple times to load several different assets.
            /// Does not assume that the hkRoootLevelContainer is the top level type.
        virtual _Ret_maybenull_ void* load(_In_z_ const char* filename, _In_ const hkReflect::Type* expectedTopLevelType);

    public:

        hkArray<hkResource*> m_loadedData;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
