// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Util/hkLoader.h>

#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Serialize/Deprecated/hkSerializeUtil.h>

hkLoader::~hkLoader()
{
    // We destruct all of the objects first in case the objects in one
    // packfile refer to those in another.
    for (int i=0; i < m_loadedData.getSize(); i++)
    {
        if (m_loadedData[i]->getReferenceCount() == 1)
        {
            m_loadedData[i]->callDestructors();
        }
    }
    for (int i=0; i < m_loadedData.getSize(); i++)
    {
        m_loadedData[i]->removeReference();
    }
    m_loadedData.setSize(0);
}

_Ret_maybenull_ hkRootLevelContainer* hkLoader::load(_In_z_ const char* filename)
{
    return static_cast<hkRootLevelContainer*>( load( filename, hkReflect::getType<hkRootLevelContainer>()) );
}

_Ret_maybenull_ hkRootLevelContainer* hkLoader::load(_Inout_ hkStreamReader* streamIn)
{
    return static_cast<hkRootLevelContainer*>( load( streamIn, hkReflect::getType<hkRootLevelContainer>() ) );
}

_Ret_maybenull_ void* hkLoader::load(_In_z_ const char* filename, _In_ const hkReflect::Type* expectedTopLevelClass)
{
    hkIstream fileIn(filename);
    if (fileIn.isOk())
    {
        return load( fileIn.getStreamReader(), expectedTopLevelClass);
    }

    HK_WARN(0x5e543234, "Unable to open file " << filename);
    return HK_NULL;
}

_Ret_maybenull_ void* hkLoader::load(_Inout_ hkStreamReader* streamIn, _In_ const hkReflect::Type* expectedTopLevelClass)
{
    hkResource* resource = hkSerializeUtil::load(streamIn);

    if( resource == HK_NULL )
    {
        HK_WARN( 0x3bf82a57, "Error loading resource");
        return HK_NULL;
    }

    void* contents = resource->getContentsPointer( expectedTopLevelClass->getName());
    if( contents != HK_NULL )
    {
        m_loadedData.pushBack(resource);
    }

    return contents;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
