// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkSerialize
{
    /// BETA - A utility for operations on inplace-loaded Havok files.
    namespace ExtraInplaceLoadUtil
    {
        /// Prepares a buffer that was loaded inplace for a new inplace load after unload.
        /// This must be called _instead_ of hkSerialize::InplaceLoad::unload(). The function will
        /// still destroy all items loaded in the file in order to cleanup the memory.
        /// unloadAndPrepareForInplaceReload() only supports little endian platforms.
        /// This operation allows a new inplaceLoad() assuming that the data wasn't dirtied or modified
        /// during usage, this includes any operation that might be happening during data use, destruction or
        /// afterReflectNew().
        ///
        /// Call this after unloading the buffer:
        /// hkSerialize::InplaceLoad inplaceLoadObject()
        /// < Use the data >
        /// hkExtraInplaceLoadUtil::unloadAndPrepareForInplaceReload()
        HK_EXPORT_COMMON hkResult HK_CALL unloadAndPrepareForInplaceReload(_Inout_updates_bytes_(bufLen) void* buf, hkUlong bufLen);

        /// Relocates a buffer that was loaded inplace.
        /// This function must be called after relocation has happened, specifying
        /// the old address and the new buffer location and size.
        /// relocateInplaceLoadBuffer() only supports little endian platforms.
        /// This operation will not work if the objects relocated make assumptions on the addresses, for instance
        /// if hashes are computed and stored based on the object address on load (afterReflectNew()) the object
        /// won't be relocatable.
        ///
        /// hkSerialize::InplaceLoad inplaceLoadObject()
        /// < Use the data >
        /// < Relocate the data >
        /// hkExtraInplaceLoadUtil::relocateInplaceLoadBuffer()
        /// < Use the data in the new location >
        HK_EXPORT_COMMON hkResult HK_CALL relocateInplaceLoadBuffer(_In_reads_bytes_(bufLen) const void* oldAddress, _Inout_updates_bytes_(bufLen) void* buf, hkUlong bufLen);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
