// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename IntegerType>
hkResult hkXmlStreamParser::getIntListAttribute(_In_z_ const char* key, hkArray<IntegerType>& out) const
{
    HK_COMPILE_TIME_ASSERT((hkTrait::IsConvertibleTo<IntegerType, hkInt64>::result));

    hkStringView subString;
    if (getValue(key, subString).isFailure())
    {
        return HK_FAILURE;
    }

    if (!(*subString.begin() == '"' && *subString.rbegin() == '"'))
    {
        return HK_FAILURE;
    }
    subString = subString.ltrim(1).rtrim(1);

    for(const char* it = subString.begin(); it < subString.end(); ++it)
    {
        // Find the next comma or end of string
        const char* endIt = it;
        while(endIt != subString.end() && *endIt != ',')
        {
            ++endIt;
        }

        hkStringView substr(it, endIt);
        hkInt64 valueOut;
        if(parseInt(substr, valueOut).isFailure())
        {
            return HK_FAILURE;
        }

        out.pushBack(static_cast<IntegerType>(valueOut));

        it = endIt;
    }

    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
