// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>

#include <Common/Base/Container/StringMap/hkStringMap.h>

#include <Common/Base/Serialize/Util/Xml/hkXmlLexAnalyzer.h>

class HK_EXPORT_COMMON hkXmlStreamParser : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

        enum Token
        {
            TOKEN_QBLOCK,
            TOKEN_BLOCK_START,
            TOKEN_BLOCK_START_END,
            TOKEN_BLOCK_END,
            TOKEN_TEXT,
            TOKEN_WHITESPACE,

            TOKEN_ERROR,
            TOKEN_EOF,
        };

            /// Advance
        Token advance();
            /// Ctor
        hkXmlStreamParser(hkIo::ReadBuffer& reader);

            ///
        hkStringView getBlockName() const;

            /// Get the current token
        HK_INLINE Token getToken() const { return m_token; }

            /// Get the keys
        HK_INLINE const hkArray<const char*>& getKeys() const { return m_keys; }
            /// Get the value
        hkResult getValue(_In_z_ const char* key, hkStringView& value) const;

            /// Get an integer attribute
        hkResult getIntAttribute(_In_z_ const char* key, int& value) const;
            /// Get the real attribute
        hkResult getRealAttribute(_In_z_ const char* key, hkReal& value) const;
            /// Gets an attribute with a list of integers (ie. attr="1,2,3")
        template<typename IntegerType>
        hkResult getIntListAttribute(_In_z_ const char* key, hkArray<IntegerType>& out) const;

            /// Returns true if the named attribute has a definition
        hkBool hasAttribute(_In_z_ const char* key) const;

            /// Get the lexeme
        hkStringView getLexeme() const;

        void dumpParse(hkOstream& out);

            /// Returns true if the subString is escaped such that it needs decoding
        static hkBool HK_CALL needsDecode(const hkStringView& subString);
            /// Decode an input string into the buf
        static hkResult HK_CALL decodeString(const hkStringView& subString, hkStringBuf& buf);

            /// Parse an int, returning sign and magnitude separately.
        static hkResult HK_CALL parseInt(const hkStringView& subString, int& signOut, hkUint64& magOut);

            /// Parse an int.
        static hkResult HK_CALL parseInt(const hkStringView& subString, hkInt64& valueOut);

            /// Parse an real
        static hkResult HK_CALL parseReal(const hkStringView& subString, hkReal& valueOut);


    protected:

        struct SubString
        {
            int m_start;
            int m_end;
        };
        void _pushLexeme();
        Token _parseBlock();
        Token _parseQBlock();
        void _extractAttributes();
        Token _advance();

        hkStringMap<int> m_attribMap;

        hkArray<const char*> m_keys;
        hkArray<char> m_keyStorage;

        hkXmlLexAnalyzer m_lex;                     ///< Lex analyzer
        hkArray<SubString> m_lexemes;               ///< Offsets to the contents

        Token m_token;
};

#include <Common/Base/Serialize/Util/Xml/hkXmlStreamParser.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
