// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Container/StringMap/hkStringMap.h>

class hkStreamReader;

namespace hkXmlObjectReader
{
    /// (Over-)Estimates the length of the decoded data from a base64 encoded string. The return value may be larger than the actual size of the decoded data
    /// if the encoded data contains whitespace or other non-encoding characters.
    HK_EXPORT_COMMON int HK_CALL estimateBase64decodedLength(hkStringView base64Data);

    /// Decodes a base64 encoded data stream. The caller needs to ensure that \c buf has enough space
    /// to hold the decoded data. Any whitespace or other non-encoding characters are ignored.
    HK_EXPORT_COMMON void HK_CALL base64read(hkStringView base64Data, _Out_writes_bytes_(_Inexpressible_(base64Data.getSize() * 3 + 2)) void* buf, _Inout_ int& decodedLengthInOut);

    HK_EXPORT_COMMON hkResult HK_CALL base64read(_Inout_ hkStreamReader* sr, _Out_writes_bytes_(decodedLength) void* buf, int decodedLength);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
