// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Util/Xml/hkXmlObjectReader.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>

static const signed char s_base64read_ascii2bin[128] =
{
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
    52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
    -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
    41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1
};

static inline void assembleBase64(hkUint8(&in)[4], hkUint8(&out)[3])
{
    out[0] = hkUint8((in[0] << 2) | (in[1] >> 4));
    out[1] = hkUint8((in[1] << 4) | (in[2] >> 2));
    out[2] = hkUint8((in[2] << 6) | (in[3] >> 0));
}

int HK_CALL hkXmlObjectReader::estimateBase64decodedLength(hkStringView base64Data)
{
    int length = base64Data.getSize();
    int decodedLength = length / 4 * 3;

    if (length > 1 && base64Data[length - 1] == '=')
    {
        decodedLength--;
    }

    if (length > 2 && base64Data[length - 2] == '=')
    {
        decodedLength--;
    }

    return decodedLength;
}

void HK_CALL hkXmlObjectReader::base64read(hkStringView base64Data, _Out_writes_bytes_(_Inexpressible_(base64Data.getSize() * 3 + 2)) void* buf, _Inout_ int& decodedLengthInOut)
{
    const int outBytesPerInBytes[4] = { 0, 0, 1, 2 };

    hkArrayBase<char> decodedData(reinterpret_cast<char*>(buf), 0, decodedLengthInOut);

    int ibuflen = 0;
    unsigned char ibuf[4] = { 0 }; // ibuf contains only 6 bit chars
    for (int in = 0; in < base64Data.getSize(); ++in)
    {
        // read char by char discarding unknown chars
        unsigned char inchar = base64Data[in];
        if (s_base64read_ascii2bin[inchar & 0x7f] != -1) // to 6 bit
        {
            ibuf[ibuflen++] = hkUint8(s_base64read_ascii2bin[inchar]);

            if (ibuflen == 4) // got a chunk
            {
                unsigned char obuf[3];
                assembleBase64(ibuf, obuf);

                ibuflen = 0;

                decodedData.pushBackUnchecked(obuf[0]);
                decodedData.pushBackUnchecked(obuf[1]);
                decodedData.pushBackUnchecked(obuf[2]);

                ibuf[0] = ibuf[1] = ibuf[2] = ibuf[3] = 0;
            }
        }
    }

    if (ibuflen) // handle leftovers
    {
        unsigned char obuf[3];
        assembleBase64(ibuf, obuf);

        for (int i = 0; i < outBytesPerInBytes[ibuflen]; ++i)
        {
            decodedData.pushBackUnchecked(obuf[i]);
        }
    }

    decodedLengthInOut = decodedData.getSize();
}

hkResult hkXmlObjectReader::base64read(_Inout_ hkStreamReader* sr, _Out_writes_bytes_(len) void* buf, int len)
{
    HK_ON_DEBUG( char peekTmp = 0 );
    HK_ASSERT( 0x5412ce0d, sr->peek(&peekTmp,1) == 1, "Stream needs to support marking");

    //XXX batch this instead of single byte reads.


    hkUint8* cur = static_cast<hkUint8*>(buf);
    const int inBytesPerOutByte[3] = { 0, 2, 3 };
    const int outBytesPerInBytes[4] = { 0, 0, 1, 2 };
    int bytesNeeded = (len/3)*4 + inBytesPerOutByte[len%3];

    int ibuflen = 0;
    unsigned char ibuf[4] = { 0 }; // ibuf contains only 6 bit chars
    while( bytesNeeded > 0 )
    {
        // read char by char discarding unknown chars
        unsigned char inchar;
        if( sr->read(&inchar, 1) != 1 )
        {
            return HK_FAILURE; // exit
        }
        if( s_base64read_ascii2bin[inchar & 0x7f] != -1 ) // to 6 bit
        {
            --bytesNeeded;
            ibuf[ ibuflen++ ] = hkUint8(s_base64read_ascii2bin[inchar]);

            if( ibuflen == 4 ) // got a chunk
            {
                unsigned char obuf[3];
                assembleBase64(ibuf, obuf);

                ibuflen = 0;
                cur[0] = obuf[0];
                cur[1] = obuf[1];
                cur[2] = obuf[2];
                cur += 3;
                ibuf[0] = ibuf[1] = ibuf[2] = ibuf[3] = 0;
            }
        }
    }

    // eat padding '='
    {
        unsigned char c = 0;
        while( sr->peek( &c, 1 ) == 1 )
        {
            sr->skip(1);
            if( c != '=' )
            {
                break;
            }
        }
    }

    if( ibuflen ) // handle leftovers
    {
        unsigned char obuf[3];
        assembleBase64(ibuf, obuf);

        for( int i = 0; i < outBytesPerInBytes[ibuflen]; ++i )
        {
            _Analysis_assume_(i<(len % 3) - 1);
            cur[i] = obuf[i];
        }
    }
    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
