// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Serialize/Util/Xml/hkParserBuffer.h>

class hkXmlLexAnalyzer: public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

        enum
        {
            IN_BRACKETS = 0x1,
            IN_QBLOCK   = 0x2
        };
        enum Token
        {
            // Only outside block
            TOKEN_START_BLOCK = 0,      ///< (Only outside brackets)
            TOKEN_START_QBLOCK,         ///< <?
            TOKEN_TEXT,                 ///< General text
            TOKEN_WHITESPACE,
            TOKEN_COMMENT,
            TOKEN_EOF,                  ///< End of file

            // Only inside a block
            TOKEN_END_BLOCK,            ///< >
            TOKEN_END_QBLOCK,           ///< ?>
            TOKEN_IDENTIFIER,
            TOKEN_EQUALS,               ///< =
            TOKEN_QUOTED_STRING,
            TOKEN_SLASH,                ///< / (Only in brackets)

            // Error token
            TOKEN_ERROR,                ///< Unable to read

            TOKEN_COUNT_OF,             ///< Count
        };
            /// Ctor
        hkXmlLexAnalyzer(hkIo::ReadBuffer& reader);
            /// Advance
        Token advance();
            /// Get the lexeme
        hkStringView getLexeme() const { return hkStringView(m_buffer.getLexemeStart(), m_buffer.getLexemeEnd()); }

            /// Get the lexeme start index
        HK_INLINE int getLexemeStartIndex() const { return m_buffer.getLexemeStartIndex(); }
            /// Get the lexeme end index
        HK_INLINE int getLexemeEndIndex() const { return m_buffer.getLexemeEndIndex(); }
            /// Get the lexeme from the indices
        HK_INLINE hkStringView getLexeme(int startIndex, int endIndex) const { return m_buffer.getLexeme(startIndex, endIndex); }

            /// Commit the buffer
        void bufferCommit() { m_buffer.bufferCommit(); }

        HK_INLINE static hkBool HK_CALL isLetter(char c) { return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'); }
        HK_INLINE static hkBool HK_CALL isDigit(char c) { return c >= '0' && c <= '9'; }
        HK_INLINE static hkBool HK_CALL isHexDigit(char c) { return isDigit(c) || (c >= 'A' && c <= 'F') || (c >= 'a' && c <= 'f'); }
        HK_INLINE static hkBool HK_CALL isAlphaNumeric(char c) { return isLetter(c) || isDigit(c); }
        HK_INLINE static hkBool HK_CALL isWhiteSpace(char c) { return c == ' ' || c == '\t' || c == 0xd || c == 0xa; }

        static const char* const tokenNames[];

    protected:
        Token _lexComment();
        Token _matchInBrackets();
        Token _lexText();
        Token _matchOutsideBrackets();
        Token _lexQuotedString();
        Token _handleError(_In_z_ const char* desc);
        Token _lexIdentifier();
        Token _lexWhiteSpace();

        hkParserBuffer m_buffer;
        int m_state;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
