// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkResource;

// Owns and links a set of resources
class HK_EXPORT_COMMON hkResourceLinker
{
public:
    typedef bool (*NameMatchesFunction)(_In_z_ const char*, _In_z_ const char*);

    static bool HK_CALL s_defaultNameMatchesFunction(_In_z_ const char*, _In_z_ const char*);
    hkResourceLinker(NameMatchesFunction f = &s_defaultNameMatchesFunction);
    ~hkResourceLinker();

    int add(hkRefPtr<hkResource> container);

    // The linker now owns these objects.
    hkResult addExport(hkReflect::Var obj, _In_z_ const char* name, bool owned = true);

    hkViewPtr<hkResource> getContainer(int index) const;

protected:
    hkArray<hkRefPtr<hkResource> > m_containers;
    NameMatchesFunction m_namesMatchFunction;

    struct HK_EXPORT_COMMON StoredObject
    {
        hkReflect::Var m_object;
        hkStringPtr m_name;
        bool m_owned;

        void set(hkReflect::Var& obj, _In_z_ const char* name, bool owned) { m_object = obj; m_name = name; m_owned = owned; }
    };
    hkArray<StoredObject> m_storedObjects;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
