// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Serialize/Resource/hkResourceLinker.h>
#include <Common/Base/Serialize/Resource/hkResource.h>

#define DEBUG_LOG_IDENTIFIER "s11n.ResourceLinker"
#include <Common/Base/System/Log/hkLog.hxx>


hkResourceLinker::hkResourceLinker(NameMatchesFunction f) : m_namesMatchFunction(f)
{
}

int hkResourceLinker::add(hkRefPtr<hkResource> container)
{
    // We can't map these particularly since we don't know what the user has given us as a matching function, it could be pulling out URLs etc

    DLOG_SCOPE("addResource {}", m_containers.getSize());

    hkArray<hkResource::Import> containerImports;
    hkArray<hkResource::Export> containerExports;
    container->getImportsExports(containerImports, containerExports);

    for(int i = 0; i < containerExports.getSize(); ++i)
    {
        DLOG_IF(hkResource::Export const& thisExport = containerExports[i]);
        DLOG("exports {} {}", thisExport.m_name, thisExport.m_location);
    }
    for(int i = 0; i < containerImports.getSize(); ++i)
    {
        DLOG_IF(hkResource::Import const& thisImport = containerImports[i]);
        DLOG("imports {} {}", thisImport.m_name, thisImport.m_location);
    }

    // First, try to match new container's exports to any existing imports
    if(containerExports.getSize())
    {
        for(int containerIndex = 0; containerIndex < m_containers.getSize(); containerIndex++)
        {
            hkRefPtr<hkResource>& loopContainer = m_containers[containerIndex];
            hkArray<hkResource::Import> loopContainerImports;
            hkArray<hkResource::Export> loopContainerExports;
            loopContainer->getImportsExports(loopContainerImports, loopContainerExports);

            for(int exportIndex = 0; exportIndex < containerExports.getSize(); exportIndex++)
            {
                hkResource::Export const& thisExport = containerExports[exportIndex];
                for(int importIndex = 0; importIndex < loopContainerImports.getSize(); importIndex++)
                {
                    hkResource::Import& loopImport = loopContainerImports[importIndex];

                    
                    if(m_namesMatchFunction(loopImport.m_name, thisExport.m_name))
                    {
                        DLOG("resolved {} *{} = {}", loopImport.m_name, loopImport.m_location, thisExport.m_location);

                        // Remove import
                        loopImport.resolve(thisExport.m_location);
                    }
                }
            }
        }
    }

    // Now, try to match new container's imports to any existing exports
    if(containerImports.getSize())
    {
        for(int containerIndex = 0; containerIndex < m_containers.getSize(); containerIndex++)
        {
            hkRefPtr<hkResource>& loopContainer = m_containers[containerIndex];
            hkArray<hkResource::Import> loopContainerImports;
            hkArray<hkResource::Export> loopContainerExports;
            loopContainer->getImportsExports(loopContainerImports, loopContainerExports);

            for(int exportIndex = 0; exportIndex < loopContainerExports.getSize(); exportIndex++)
            {
                hkResource::Export const& loopExport = loopContainerExports[exportIndex];
                for(int importIndex = 0; importIndex < containerImports.getSize(); importIndex++)
                {
                    hkResource::Import& thisImport = containerImports[importIndex];
                    
                    if(m_namesMatchFunction(thisImport.m_name, loopExport.m_name))
                    {
                        DLOG("resolved {} *{} = {}", thisImport.m_name, thisImport.m_location, loopExport.m_location);
                        // Remove import
                        thisImport.resolve(loopExport.m_location);
                    }
                }
            }
        }

        for(int storedObjectIndex = 0; storedObjectIndex < m_storedObjects.getSize(); storedObjectIndex++)
        {
            StoredObject& loopStoredObject = m_storedObjects[storedObjectIndex];
            for(int importIndex = 0; importIndex < containerImports.getSize(); importIndex++)
            {
                hkResource::Import& thisImport = containerImports[importIndex];

                if(m_namesMatchFunction(thisImport.m_name, loopStoredObject.m_name))
                {
                    DLOG("resolved {} *{} = {}", thisImport.m_name, thisImport.m_location, loopStoredObject.m_object);
                    // Remove import
                    thisImport.resolve(loopStoredObject.m_object);
                }
            }
        }
    }

    m_containers.pushBack(container);

    return m_containers.getSize() - 1;
}

hkResult hkResourceLinker::addExport(hkReflect::Var obj, _In_z_ const char* name, bool owned)
{
    DLOG_SCOPE("addExport {} {}", name, obj);

    // First, try to match new container's exports to any existing imports
    for(int containerIndex = 0; containerIndex < m_containers.getSize(); containerIndex++)
    {
        hkRefPtr<hkResource>& loopContainer = m_containers[containerIndex];
        hkArray<hkResource::Import> loopContainerImports;
        hkArray<hkResource::Export> loopContainerExports;
        loopContainer->getImportsExports(loopContainerImports, loopContainerExports);

        for(int importIndex = 0; importIndex < loopContainerImports.getSize(); importIndex++)
        {
            hkResource::Import& loopImport = loopContainerImports[importIndex];
            if(m_namesMatchFunction(loopImport.m_name, name))
            {
                DLOG("resolved {} *{} = {}", name, loopImport.m_location, obj );
                // Remove import
                loopImport.resolve(obj);
            }
        }
    }

    m_storedObjects.expandOne().set(obj, name, owned);

    return HK_SUCCESS;
}

bool HK_CALL hkResourceLinker::s_defaultNameMatchesFunction(_In_z_ const char* a, _In_z_ const char* b)
{
    return hkString::strCmp(a, b) == 0;
}

hkResourceLinker::~hkResourceLinker()
{
    for(int i=0; i < m_storedObjects.getSize(); i++)
    {
        if(m_storedObjects[i].m_owned)
        {
            // Do this simply for now
            if(hkReferencedObject* ro = m_storedObjects[i].m_object.dynCast<hkReferencedObject>())
            {
                ro->removeReference();
            }
            else
            {
                const hkReflect::Type* objectType = m_storedObjects[i].m_object.getType();
                void* object = m_storedObjects[i].m_object.getAddress();

                hkReflect::Var v(object, objectType);
                v.destroy();
            }
        }
    }
}

hkViewPtr<hkResource> hkResourceLinker::getContainer(int index) const
{
    return m_containers[index];
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
