// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/hkBaseTypes.h>

    /// Abstract base class for resources which require cleanup.
class HK_EXPORT_COMMON hkResource : public hkReferencedObject
{
    public:
    HK_DECLARE_CLASS(hkResource, New, ReflectIdentity);
            /// Object which this resource provides.
    struct Import
    {
        hkReflect::PointerVar m_location;
        hkStringPtr m_name;

        void resolve(const hkReflect::Var& target) const { m_location.setValue(target); }
        void set(const hkReflect::PointerVar& loc, _In_z_ const char* name) { m_location = loc; m_name = name; }
    };

    struct Export
    {
        hkReflect::Var m_location;
        hkStringPtr m_name;
        int m_count;
        void set(const hkReflect::Var& loc, _In_z_ const char* name, int count = 0) { m_location = loc; m_name = name; m_count = count; }
    };

    public:

            /// Get the name of this resource.
        virtual _Ret_maybenull_z_ const char* getName() const = 0;

            /// Destroy the resource data.
            /// All contained objects are first destroyed then any allocated
            /// memory is freed. See also callDestructors().
        virtual ~hkResource() { }

            /// Destruct objects.
            /// This method is separate from ~hkResource() because if multiple
            /// resources reference each other, it will usually be necessary to perform
            /// two passes. e.g because otherwise the destructors could call removeReference
            /// on freed memory. The first pass calls all destructors. The second pass frees memory.
        virtual void callDestructors() { }

            /// Get a list of the imports/exports from this resource.
        virtual void getImportsExports( hkArray<Import>& impOut, hkArray<Export>& expOut ) const = 0;

        virtual _Ret_maybenull_ void* getContentsPointer(_In_opt_z_ const char* typeName) const;

            /// Get contents from a type. A string typename can not completely
            /// describe a template, this requires a complete source type
        virtual _Ret_maybenull_ void* getContentsPointer(_In_opt_ const hkReflect::Type* type) const;

            /// Return pointer to a top level object of specified type T.
        template<typename T>
        _Ret_maybenull_ T* getContents() const;

            /// Return the top level object type name.
        virtual _Ret_z_ const char* getContentsTypeName() const;
        virtual _Ret_notnull_ const hkReflect::Type* getContentsType() const;

        virtual hkReflect::Var getContents() const = 0; // All of the other methods call this one

            /// Release any temporary data associated with loading. After calling this, contents are fixed
        virtual void cleanup() {}

            /// If this object was named in this resource, return the name, else return HK_NULL
        virtual bool getObjectName(_In_ const void* object, hkStringBuf& nameOut) const;
};

#include <Common/Base/Serialize/Resource/hkResource.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
